/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.json.animation.JFrame;

public class JAnimation
implements Cloneable {
    private Boolean interpolate;
    private Integer width;
    private Integer height;
    private Integer frametime;
    private List<JFrame> frames;
    private List<Integer> defaultFrames;

    public static JAnimation animation() {
        return new JAnimation();
    }

    public static JFrame frame(int index) {
        return new JFrame(index);
    }

    public JAnimation clone() {
        try {
            return (JAnimation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public JAnimation interpolate() {
        this.interpolate = true;
        return this;
    }

    public JAnimation width(int width) {
        this.width = width;
        return this;
    }

    public JAnimation height(int height) {
        this.height = height;
        return this;
    }

    public JAnimation frameTime(int time) {
        this.frametime = time;
        return this;
    }

    public JAnimation add(int frame) {
        if (this.defaultFrames == null) {
            this.defaultFrames = new ArrayList<Integer>();
        }
        this.defaultFrames.add(frame);
        return this;
    }

    public JAnimation add(JFrame frame) {
        if (this.frames == null) {
            this.frames = new ArrayList<JFrame>();
        }
        this.frames.add(frame);
        return this;
    }

    public static class Serializer
    implements JsonSerializer<JAnimation> {
        public JsonElement serialize(JAnimation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            JsonObject animation = new JsonObject();
            if (src.interpolate != null) {
                animation.addProperty("interpolate", src.interpolate);
            }
            if (src.width != null) {
                animation.addProperty("width", (Number)src.width);
            }
            if (src.height != null) {
                animation.addProperty("height", (Number)src.height);
            }
            if (src.frametime != null) {
                animation.addProperty("frametime", (Number)src.frametime);
            }
            JsonArray frames = new JsonArray();
            if (src.frames != null) {
                for (JFrame jFrame : src.frames) {
                    frames.add(context.serialize((Object)jFrame));
                }
            }
            if (src.defaultFrames != null) {
                for (Integer n : src.defaultFrames) {
                    frames.add((Number)n);
                }
            }
            if (frames.size() > 0) {
                animation.add("frames", (JsonElement)frames);
            }
            object.add("animation", (JsonElement)animation);
            return object;
        }
    }
}

