/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.bounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import java.util.function.Function;
import net.minecraft.class_5866;
import net.minecraft.class_6019;

public final class UniformedNumberCodecs {
    public static final Codec<class_5866> FLOAT_CODEC = UniformedNumberCodecs.getFloatCodec();
    public static final Codec<class_6019> INT_CODEC = UniformedNumberCodecs.getIntCodec();

    private UniformedNumberCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    private static Codec<class_5866> getFloatCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(class_5866::method_33915), (App)Codec.FLOAT.fieldOf("max").forGetter(class_5866::method_33921)).apply((Applicative)instance, class_5866::method_33934));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.method_33921() < uniformFloat.method_33915()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformFloat.method_33915() + ", max: " + uniformFloat.method_33921());
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }

    public static Codec<class_6019> getIntCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(class_6019::method_35009), (App)Codec.INT.fieldOf("max").forGetter(class_6019::method_35011)).apply((Applicative)instance, class_6019::method_35017));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.method_35011() < uniformInt.method_35009()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformInt.method_35009() + ", max: " + uniformInt.method_35011());
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<class_6019> rangedUniformIntCodec(int min, int max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)min, (int)max).fieldOf("min").forGetter(class_6019::method_35009), (App)Codec.intRange((int)min, (int)max).fieldOf("max").forGetter(class_6019::method_35011)).apply((Applicative)instance, class_6019::method_35017));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.method_35011() < uniformInt.method_35009()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformInt.method_35009() + ", max: " + uniformInt.method_35011());
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<class_5866> rangedUniformFloatCodec(float min, float max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)min, (float)max).fieldOf("min").forGetter(class_5866::method_33915), (App)Codec.floatRange((float)min, (float)max).fieldOf("max").forGetter(class_5866::method_33921)).apply((Applicative)instance, class_5866::method_33934));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.method_33921() < uniformFloat.method_33915()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformFloat.method_33915() + ", max: " + uniformFloat.method_33921());
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }
}

