/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.world.event;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7659;
import net.minecraft.class_7723;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.class_8100;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.OnWorldLoad;
import org.betterx.worlds.together.world.event.WorldEventsImpl;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WorldBootstrap {
    private static class_5455 LAST_REGISTRY_ACCESS = null;
    private static byte WARN_COUNT_GLOBAL_REGISTRY = 0;

    public static class_5455 getLastRegistryAccess() {
        return LAST_REGISTRY_ACCESS;
    }

    public static class_5455 getLastRegistryAccessOrElseBuiltin() {
        if (WARN_COUNT_GLOBAL_REGISTRY < 10 && LAST_REGISTRY_ACCESS == null && Configs.MAIN_CONFIG.verboseLogging()) {
            WorldsTogether.LOGGER.error("Tried to read from global registry!");
            WARN_COUNT_GLOBAL_REGISTRY = (byte)(WARN_COUNT_GLOBAL_REGISTRY + 1);
        }
        return LAST_REGISTRY_ACCESS;
    }

    private static void setupWorld(class_32.class_5143 levelStorageAccess, Map<class_5321<class_5363>, class_2794> dimensions, boolean newWorld, boolean isServer) {
        try {
            Helpers.initializeWorldConfig(levelStorageAccess, newWorld);
            WorldEventsImpl.BEFORE_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, dimensions, newWorld, isServer));
        }
        catch (Exception e2) {
            WorldsTogether.LOGGER.error("Failed to initialize data in world", e2);
        }
    }

    private static void writeWorldPresets(class_7723 dimensions, class_6880<class_7145> currentPreset) {
        Object object;
        if ((currentPreset = WorldEventsImpl.ADAPT_WORLD_PRESET.emit(currentPreset, dimensions)) != null && (object = currentPreset.comp_349()) instanceof WorldPresetAccessor) {
            WorldPresetAccessor acc = (WorldPresetAccessor)object;
            TogetherWorldPreset.writeWorldPresetSettings(acc.bcl_getDimensions());
        } else {
            WorldsTogether.LOGGER.error("Failed writing together File");
            TogetherWorldPreset.writeWorldPresetSettings(dimensions);
        }
    }

    public static void finishedWorldLoad() {
        WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
    }

    public static void finalizeWorldGenSettings(class_2378<class_5363> dimensionRegistry) {
        Object output = "World Dimensions: ";
        for (Map.Entry entry : dimensionRegistry.method_29722()) {
            WorldEventsImpl.ON_FINALIZE_LEVEL_STEM.emit(e -> e.now(dimensionRegistry, (class_5321<class_5363>)((class_5321)entry.getKey()), (class_5363)entry.getValue()));
            if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
            output = (String)output + "\n - " + ((class_5321)entry.getKey()).method_29177().toString() + ": \n     " + ((class_5363)entry.getValue()).comp_1013().toString() + " " + ((class_5363)entry.getValue()).comp_1013().method_12098().toString().replace("\n", "\n     ");
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info((String)output);
        }
        SurfaceRuleUtil.injectSurfaceRulesToAllDimensions(dimensionRegistry);
        WorldEventsImpl.ON_FINALIZED_WORLD_LOAD.emit(e -> e.done(dimensionRegistry));
    }

    public static class_7780<class_7659> enforceInLayeredRegistry(class_7780<class_7659> registries) {
        class_5455.class_6890 access = registries.method_45926();
        Helpers.onRegistryReady((class_5455)access);
        class_2378 dimensions = access.method_30530(class_7924.field_41224);
        class_2378<class_5363> changedDimensions = WorldGenUtil.repairBiomeSourceInAllDimensions((class_5455)access, (class_2378<class_5363>)dimensions);
        if (dimensions != changedDimensions) {
            if (Configs.MAIN_CONFIG.verboseLogging()) {
                WorldsTogether.LOGGER.info("Loading originally configured Dimensions in World.");
            }
            registries = registries.method_45930((Object)class_7659.field_39973, new class_5455.class_6890[]{new class_5455.class_6891(List.of(changedDimensions)).method_40316()});
            Helpers.onRegistryReady((class_5455)registries.method_45926());
        }
        return registries;
    }

    public static class Helpers {
        private static void initializeWorldConfig(class_32.class_5143 levelStorageAccess, boolean newWorld) {
            File levelPath = levelStorageAccess.method_27010(class_5218.field_24188).toFile();
            Helpers.initializeWorldConfig(levelPath, newWorld);
        }

        private static void initializeWorldConfig(File levelBaseDir, boolean newWorld) {
            WorldConfig.load(new File(levelBaseDir, "data"));
        }

        private static void onRegistryReady(class_5455 a) {
            if (a != LAST_REGISTRY_ACCESS) {
                LAST_REGISTRY_ACCESS = a;
                WorldEventsImpl.WORLD_REGISTRY_READY.emit(e -> e.initRegistry(a));
            }
        }

        private static class_6880<class_7145> defaultServerPreset() {
            return WorldPresets.get(LAST_REGISTRY_ACCESS, WorldPresets.getDEFAULT());
        }

        private static class_7723 defaultServerDimensions() {
            class_6880<class_7145> defaultPreset = Helpers.defaultServerPreset();
            return Helpers.defaultServerDimensions(defaultPreset);
        }

        private static class_7723 defaultServerDimensions(class_6880<class_7145> defaultPreset) {
            class_7723 dimensions;
            Object object = defaultPreset.comp_349();
            if (object instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = (TogetherWorldPreset)((Object)object);
                dimensions = t.getWorldDimensions();
            } else {
                dimensions = TogetherWorldPreset.getWorldDimensions((class_5321<class_7145>)class_5317.field_25050);
            }
            return dimensions;
        }

        private static class_6880<class_7145> presetFromDatapack(class_6880<class_7145> currentPreset) {
            Optional presetKey;
            if (currentPreset != null && LAST_REGISTRY_ACCESS != null && (presetKey = currentPreset.method_40230()).isPresent()) {
                Optional newPreset = LAST_REGISTRY_ACCESS.method_30530(class_7924.field_41250).method_40264((class_5321)presetKey.get());
                currentPreset = newPreset.orElse(null);
            }
            return currentPreset;
        }
    }

    public static class InFreshLevel {
        public static void setupNewWorld(String levelID, class_7723 worldDims, class_32 levelSource, class_6880<class_7145> worldPreset) {
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                InGUI.setupNewWorldCommon(levelStorageAccess, worldPreset, worldDims, false);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
        }
    }

    public static class InGUI {
        public static void registryReadyOnNewWorld(class_7193 worldGenSettingsComponent) {
            Helpers.onRegistryReady((class_5455)worldGenSettingsComponent.method_45689());
        }

        public static void registryReady(class_5455 access) {
            Helpers.onRegistryReady(access);
        }

        public static void setupNewWorld(Optional<class_32.class_5143> levelStorageAccess, class_8100 uiState, boolean recreated) {
            if (levelStorageAccess.isPresent()) {
                class_6880<class_7145> currentPreset = uiState.method_48730().comp_1238();
                currentPreset = Helpers.presetFromDatapack(currentPreset);
                class_6880<class_7145> newPreset = InGUI.setupNewWorldCommon(levelStorageAccess.get(), currentPreset, uiState.method_48728().comp_1028(), recreated);
                if (newPreset != null && newPreset != currentPreset) {
                    uiState.method_48705(new class_8100.class_8101(newPreset));
                }
            } else {
                WorldsTogether.LOGGER.error("Unable to access Level Folder.");
            }
        }

        static class_6880<class_7145> setupNewWorldCommon(class_32.class_5143 levelStorageAccess, class_6880<class_7145> currentPreset, class_7723 worldDims, boolean recreated) {
            class_7723 dimensions;
            Object object;
            if (currentPreset != null && (object = currentPreset.comp_349()) instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = (TogetherWorldPreset)((Object)object);
                dimensions = t.getWorldDimensions();
            } else {
                dimensions = recreated ? worldDims : TogetherWorldPreset.getWorldDimensions((class_5321<class_7145>)class_5317.field_25050);
            }
            WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.getDimensionMap(dimensions), true, false);
            WorldBootstrap.writeWorldPresets(worldDims, currentPreset);
            WorldBootstrap.finishedWorldLoad();
            return currentPreset;
        }

        public static void setupLoadedWorld(String levelID, class_32 levelSource) {
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false, false);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to acquire storage access", e);
            }
        }

        public static boolean applyWorldPatches(class_32 levelSource, String levelID, Consumer<Boolean> onResume) {
            boolean result = false;
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                result = WorldEventsImpl.PATCH_WORLD.applyPatches(levelStorageAccess, onResume);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
            return result;
        }
    }

    public static class DedicatedServer {
        public static void registryReady(class_5455 acc) {
            Helpers.onRegistryReady(acc);
        }

        public static void setupWorld(class_32.class_5143 levelStorageAccess) {
            File levelDat = levelStorageAccess.method_27010(class_5218.field_24184).toFile();
            if (!levelDat.exists()) {
                WorldsTogether.LOGGER.info("Creating a new World, no fixes needed");
                class_7723 dimensions = Helpers.defaultServerDimensions();
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.getDimensionMap(dimensions), true, true);
                class_6880<class_7145> currentPreset = Helpers.defaultServerPreset();
                WorldBootstrap.writeWorldPresets(dimensions, currentPreset);
                WorldBootstrap.finishedWorldLoad();
            } else {
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false, true);
                WorldBootstrap.finishedWorldLoad();
            }
        }

        public static boolean applyWorldPatches(class_32.class_5143 levelStorageAccess) {
            boolean result = false;
            if (levelStorageAccess.method_27010(class_5218.field_24184).toFile().exists()) {
                try {
                    result = WorldEventsImpl.PATCH_WORLD.applyPatches(levelStorageAccess, null);
                }
                catch (Exception e) {
                    WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
                }
            }
            return result;
        }
    }
}

