/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api.variant;

import draylar.identity.api.variant.TypeProvider;
import draylar.identity.impl.variant.AxolotlTypeProvider;
import draylar.identity.impl.variant.CatTypeProvider;
import draylar.identity.impl.variant.FoxTypeProvider;
import draylar.identity.impl.variant.FrogTypeProvider;
import draylar.identity.impl.variant.ParrotTypeProvider;
import draylar.identity.impl.variant.SheepTypeProvider;
import draylar.identity.impl.variant.SlimeTypeProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class IdentityType<T extends class_1309> {
    private static final List<class_1299<? extends class_1309>> LIVING_TYPE_CASH = new ArrayList<class_1299<? extends class_1309>>();
    private static final Map<class_1299<? extends class_1309>, TypeProvider<?>> VARIANT_BY_TYPE = new LinkedHashMap();
    private final class_1299<T> type;
    private final int variantData;

    public IdentityType(class_1299<T> type) {
        this.type = type;
        this.variantData = this.getDefaultVariantData(type);
    }

    private int getDefaultVariantData(class_1299<T> type) {
        if (VARIANT_BY_TYPE.containsKey(type)) {
            return VARIANT_BY_TYPE.get(type).getFallbackData();
        }
        return -1;
    }

    public IdentityType(class_1299<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public IdentityType(T entity) {
        this.type = entity.method_5864();
        @Nullable TypeProvider<?> provider = VARIANT_BY_TYPE.get(this.type);
        this.variantData = provider != null ? provider.getVariantData(entity) : this.getDefaultVariantData(this.type);
    }

    @Nullable
    public static <Z extends class_1309> IdentityType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }
        class_1299 type = entity.method_5864();
        if (VARIANT_BY_TYPE.containsKey(type)) {
            TypeProvider<?> typeProvider = VARIANT_BY_TYPE.get(type);
            return typeProvider.create(type, entity);
        }
        return new IdentityType<class_1299>(entity.method_5864());
    }

    @Nullable
    public static IdentityType<?> from(class_2487 compound) {
        class_2960 id = new class_2960(compound.method_10558("EntityID"));
        if (!class_7923.field_41177.method_10250(id)) {
            return null;
        }
        return new IdentityType((class_1299)class_7923.field_41177.method_10223(id), compound.method_10545("Variant") ? compound.method_10550("Variant") : -1);
    }

    public static List<IdentityType<?>> getAllTypes(class_1937 world) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (class_1299 type : class_7923.field_41177) {
                class_1297 instance = type.method_5883(world);
                if (!(instance instanceof class_1309)) continue;
                LIVING_TYPE_CASH.add((class_1299<? extends class_1309>)type);
            }
        }
        ArrayList types = new ArrayList();
        for (class_1299<? extends class_1309> type : LIVING_TYPE_CASH) {
            if (VARIANT_BY_TYPE.containsKey(type)) {
                TypeProvider<?> variant = VARIANT_BY_TYPE.get(type);
                for (int i = 0; i <= variant.getRange(); ++i) {
                    types.add(new IdentityType<class_1309>(type, i));
                }
                continue;
            }
            types.add(new IdentityType<class_1299<? extends class_1309>>(type));
        }
        return types;
    }

    @Nullable
    public static <Z extends class_1309> IdentityType<Z> from(class_1299<?> entityType, int variant) {
        if (VARIANT_BY_TYPE.containsKey(entityType)) {
            TypeProvider<?> provider = VARIANT_BY_TYPE.get(entityType);
            if (variant < -1 || variant > provider.getRange()) {
                return null;
            }
        }
        return new IdentityType(entityType, variant);
    }

    public class_2487 writeCompound() {
        class_2487 compound = new class_2487();
        compound.method_10582("EntityID", class_7923.field_41177.method_10221(this.type).toString());
        compound.method_10569("Variant", this.variantData);
        return compound;
    }

    public class_1299<? extends class_1309> getEntityType() {
        return this.type;
    }

    public T create(class_1937 world) {
        TypeProvider<?> typeProvider = VARIANT_BY_TYPE.get(this.type);
        if (typeProvider != null) {
            return (T)typeProvider.create(this.type, world, this.variantData);
        }
        return (T)((class_1309)this.type.method_5883(world));
    }

    public int getVariantData() {
        return this.variantData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityType that = (IdentityType)o;
        return this.variantData == that.variantData && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantData);
    }

    public void writeEntityNbt(class_2487 tag) {
        class_2487 inner = this.writeCompound();
        tag.method_10566("IdentityType", (class_2520)inner);
    }

    public static IdentityType<?> fromEntityNbt(class_2487 tag) {
        return IdentityType.from(tag.method_10562("IdentityType"));
    }

    public class_2561 createTooltipText(T entity) {
        TypeProvider<?> provider = VARIANT_BY_TYPE.get(this.type);
        if (provider != null) {
            return provider.modifyText(entity, class_2561.method_43471((String)this.type.method_5882()));
        }
        return class_2561.method_43471((String)this.type.method_5882());
    }

    static {
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_6115, new SheepTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_28315, new AxolotlTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_6104, new ParrotTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_17943, new FoxTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_16281, new CatTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_6069, new SlimeTypeProvider());
        VARIANT_BY_TYPE.put((class_1299<? extends class_1309>)class_1299.field_37419, new FrogTypeProvider());
    }
}

