/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class IdentityCommand {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, b) -> {
            LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"identity").requires(source -> source.method_9259(2))).build();
            LiteralCommandNode grantNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"grant").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"everything").executes(context -> {
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.method_37908())) {
                    if (PlayerUnlocks.has((class_1657)player, type)) continue;
                    PlayerUnlocks.unlock(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> {
                IdentityCommand.grant(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.grant(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode revokeNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"revoke").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"everything").executes(context -> {
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.method_37908())) {
                    if (!PlayerUnlocks.has((class_1657)player, type)) continue;
                    PlayerUnlocks.revoke(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> {
                IdentityCommand.revoke(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.revoke(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode equip = ((LiteralArgumentBuilder)class_2170.method_9247((String)"equip").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> {
                IdentityCommand.equip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.equip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177(), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode unequip = ((LiteralArgumentBuilder)class_2170.method_9247((String)"unequip").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
                IdentityCommand.unequip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"));
                return 1;
            }))).build();
            LiteralCommandNode test = ((LiteralArgumentBuilder)class_2170.method_9247((String)"test").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"not").then(class_2170.method_9244((String)"identity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> IdentityCommand.testNot(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177()))))).then(class_2170.method_9244((String)"identity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> IdentityCommand.test(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_7733.method_45610((CommandContext)context, (String)"identity").method_40237().method_29177()))))).build();
            rootNode.addChild((CommandNode)grantNode);
            rootNode.addChild((CommandNode)revokeNode);
            rootNode.addChild((CommandNode)equip);
            rootNode.addChild((CommandNode)unequip);
            rootNode.addChild((CommandNode)test);
            dispatcher.getRoot().addChild((CommandNode)rootNode);
        });
    }

    private static int test(class_3222 source, class_3222 player, class_2960 identity) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(identity);
        if (PlayerIdentity.getIdentity((class_1657)player) != null && PlayerIdentity.getIdentity((class_1657)player).method_5864().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_positive", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_failed", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
        }
        return 0;
    }

    private static int testNot(class_3222 source, class_3222 player, class_2960 identity) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(identity);
        if (PlayerIdentity.getIdentity((class_1657)player) != null && !PlayerIdentity.getIdentity((class_1657)player).method_5864().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_failed", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_positive", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
        }
        return 0;
    }

    private static void grant(class_3222 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        IdentityType<class_1299> type = new IdentityType<class_1299>((class_1299)class_7923.field_41177.method_10223(id));
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_51469();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new IdentityType<class_1309>(living);
                name = type.createTooltipText((class_1299)living);
            }
        }
        if (!PlayerUnlocks.has((class_1657)player, type)) {
            boolean result = PlayerUnlocks.unlock(player, type);
            if (result && IdentityConfig.getInstance().logCommands()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"identity.unlock_entity", (Object[])new Object[]{name}), true);
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.grant_success", (Object[])new Object[]{name, player.method_5476()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.already_has", (Object[])new Object[]{player.method_5476(), name}), true);
        }
    }

    private static void revoke(class_3222 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        IdentityType<class_1299> type = new IdentityType<class_1299>((class_1299)class_7923.field_41177.method_10223(id));
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_51469();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new IdentityType<class_1309>(living);
                name = type.createTooltipText((class_1299)living);
            }
        }
        if (PlayerUnlocks.has((class_1657)player, type)) {
            PlayerUnlocks.revoke(player, type);
            if (IdentityConfig.getInstance().logCommands()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"identity.revoke_entity", (Object[])new Object[]{name}), true);
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.revoke_success", (Object[])new Object[]{name, player.method_5476()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.does_not_have", (Object[])new Object[]{player.method_5476(), name}), true);
        }
    }

    private static void equip(class_3222 source, class_3222 player, class_2960 identity, @Nullable class_2487 nbt) {
        boolean result;
        class_1309 living;
        IdentityType<class_1309> defaultType;
        class_1297 created;
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", identity.toString());
            class_3218 serverWorld = source.method_51469();
            created = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
        } else {
            class_1299 entity = (class_1299)class_7923.field_41177.method_10223(identity);
            created = entity.method_5883(player.method_37908());
        }
        if (created instanceof class_1309 && (defaultType = IdentityType.from(living = (class_1309)created)) != null && (result = PlayerIdentity.updateIdentity(player, defaultType, (class_1309)created)) && IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.equip_success", (Object[])new Object[]{class_2561.method_43471((String)created.method_5864().method_5882()), player.method_5476()}), true);
        }
    }

    private static void unequip(class_3222 source, class_3222 player) {
        boolean result = PlayerIdentity.updateIdentity(player, null, null);
        if (result && IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.unequip_success", (Object[])new Object[]{player.method_5476()}), false);
        }
    }
}

