/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network;

import dev.architectury.networking.NetworkManager;
import draylar.identity.IdentityClient;
import draylar.identity.api.ApplicablePacket;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.UnlockPackets;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.IDENTITY_SYNC, ClientNetworking::handleIdentitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.FAVORITE_SYNC, FavoritePackets::handleFavoriteSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.CONFIG_SYNC, ClientNetworking::handleConfigurationSyncPacket);
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            IdentityClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        NetworkManager.sendToServer((class_2960)USE_ABILITY, (class_2540)new class_2540(Unpooled.buffer()));
    }

    public static void handleIdentitySyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        UUID uuid = packet.method_10790();
        String id = packet.method_19772();
        class_2487 entityNbt = packet.method_10798();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_5770().method_18470(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.setIdentity(null);
                    ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                    return;
                }
                if (entityNbt != null) {
                    entityNbt.method_10582("id", id);
                    Optional type = class_1299.method_17684((class_2487)entityNbt);
                    if (type.isPresent()) {
                        class_1309 identity = data.getIdentity();
                        if (identity == null || !((class_1299)type.get()).equals(identity.method_5864())) {
                            identity = (class_1309)((class_1299)type.get()).method_5883(syncTarget.method_37908());
                            data.setIdentity(identity);
                            ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                        }
                        if (identity != null) {
                            identity.method_5651(entityNbt);
                        }
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        int cooldown = packet.readInt();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).setAbilityCooldown(cooldown));
    }

    public static void handleConfigurationSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        boolean enableClientSwapMenu = packet.readBoolean();
        boolean showPlayerNametag = packet.readBoolean();
    }

    private ClientNetworking() {
    }
}

