/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.ClientNetworking;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FavoritePackets {
    public static void sendFavoriteRequest(IdentityType<?> type, boolean favorite) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10812(class_7923.field_41177.method_10221(type.getEntityType()));
        packet.writeInt(type.getVariantData());
        packet.writeBoolean(favorite);
        NetworkManager.sendToServer((class_2960)ClientNetworking.FAVORITE_UPDATE, (class_2540)packet);
    }

    public static void registerFavoriteRequestHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)NetworkHandler.FAVORITE_UPDATE, (buf, context) -> {
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(buf.method_10810());
            int variant = buf.readInt();
            boolean favorite = buf.readBoolean();
            class_3222 player = (class_3222)context.getPlayer();
            context.getPlayer().method_5682().execute(() -> {
                @Nullable IdentityType<Z> type = IdentityType.from(entityType, variant);
                if (type != null) {
                    if (favorite) {
                        PlayerFavorites.favorite(player, type);
                    } else {
                        PlayerFavorites.unfavorite(player, type);
                    }
                }
            });
        });
    }

    public static void sendFavoriteSync(class_3222 player) {
        Set<IdentityType<?>> favorites = ((PlayerDataProvider)player).getFavorites();
        class_2487 tag = new class_2487();
        class_2499 idList = new class_2499();
        favorites.forEach(type -> idList.add((Object)type.writeCompound()));
        tag.method_10566("FavoriteIdentities", (class_2520)idList);
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10794(tag);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)NetworkHandler.FAVORITE_SYNC, (class_2540)packet);
    }

    public static void handleFavoriteSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_2487 tag = packet.method_10798();
        ClientNetworking.runOrQueue(context, player -> {
            PlayerDataProvider data = (PlayerDataProvider)player;
            data.getFavorites().clear();
            class_2499 idList = tag.method_10554("FavoriteIdentities", 10);
            idList.forEach(compound -> data.getFavorites().add(IdentityType.from((class_2487)compound)));
        });
    }
}

