/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModrinthData;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModrinthUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu/Update Checker");
    private static final HttpClient client = HttpClient.newHttpClient();
    private static boolean apiV2Deprecated = false;

    private static boolean allowsUpdateChecks(Mod mod) {
        return mod.allowsUpdateChecks();
    }

    public static void checkForUpdates() {
        if (apiV2Deprecated || !ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return;
        }
        class_156.method_18349().execute(() -> {
            LOGGER.info("Checking mod updates...");
            HashMap modHashes = new HashMap();
            new ArrayList<Mod>(ModMenu.MODS.values()).stream().filter(ModrinthUtil::allowsUpdateChecks).forEach(mod -> {
                String modId = mod.getId();
                try {
                    String hash = mod.getSha512Hash();
                    if (hash != null) {
                        LOGGER.debug("Hash for {} is {}", (Object)modId, (Object)hash);
                        modHashes.putIfAbsent(hash, new HashSet());
                        ((Set)modHashes.get(hash)).add(mod);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error getting mod hash for mod {}: ", (Object)modId, (Object)e);
                }
            });
            String environment = ModMenu.devEnvironment ? "/development" : "";
            String primaryLoader = ModMenu.runningQuilt ? "quilt" : "fabric";
            List<String> loaders = ModMenu.runningQuilt ? List.of("fabric", "quilt") : List.of("fabric");
            String mcVer = class_155.method_16673().method_48019();
            String[] splitVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("modmenu").get()).getMetadata().getVersion().getFriendlyString().split("\\+", 1);
            String modMenuVersion = splitVersion.length > 1 ? splitVersion[1] : splitVersion[0];
            String userAgent = "%s/%s (%s/%s%s)".formatted("TerraformersMC/ModMenu", modMenuVersion, mcVer, primaryLoader, environment);
            String body = ModMenu.GSON_MINIFIED.toJson((Object)new LatestVersionsFromHashesBody(modHashes.keySet(), loaders, mcVer));
            LOGGER.debug("User agent: " + userAgent);
            LOGGER.debug("Body: " + body);
            HttpRequest latestVersionsRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body)).header("User-Agent", userAgent).header("Content-Type", "application/json").uri(URI.create("https://api.modrinth.com/v2/version_files/update")).build();
            try {
                HttpResponse<String> latestVersionsResponse = client.send(latestVersionsRequest, HttpResponse.BodyHandlers.ofString());
                int status = latestVersionsResponse.statusCode();
                LOGGER.debug("Status: " + status);
                if (status == 410) {
                    apiV2Deprecated = true;
                    LOGGER.warn("Modrinth API v2 is deprecated, unable to check for mod updates.");
                } else if (status == 200) {
                    JsonObject responseObject = JsonParser.parseString((String)latestVersionsResponse.body()).getAsJsonObject();
                    LOGGER.debug(String.valueOf(responseObject));
                    responseObject.asMap().forEach((lookupHash, versionJson) -> {
                        JsonObject versionObj = versionJson.getAsJsonObject();
                        String projectId = versionObj.get("project_id").getAsString();
                        String versionNumber = versionObj.get("version_number").getAsString();
                        String versionId = versionObj.get("id").getAsString();
                        Optional<JsonElement> primaryFile = versionObj.get("files").getAsJsonArray().asList().stream().filter(file -> file.getAsJsonObject().get("primary").getAsBoolean()).findFirst();
                        if (primaryFile.isEmpty()) {
                            return;
                        }
                        String versionHash = primaryFile.get().getAsJsonObject().get("hashes").getAsJsonObject().get("sha512").getAsString();
                        if (!Objects.equals(versionHash, lookupHash)) {
                            ((Set)modHashes.get(lookupHash)).forEach(mod -> {
                                LOGGER.info("Update available for '{}@{}', (-> {})", new Object[]{mod.getId(), mod.getVersion(), versionNumber});
                                mod.setModrinthData(new ModrinthData(projectId, versionId, versionNumber));
                            });
                        }
                    });
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error("Error checking for updates: ", (Throwable)e);
            }
        });
    }

    public static void triggerV2DeprecatedToast() {
        if (apiV2Deprecated && ModMenuConfig.UPDATE_CHECKER.getValue()) {
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)class_2561.method_43471((String)"modmenu.modrinth.v2_deprecated.title"), (class_2561)class_2561.method_43471((String)"modmenu.modrinth.v2_deprecated.description")));
        }
    }

    public static class LatestVersionsFromHashesBody {
        public Collection<String> hashes;
        public String algorithm = "sha512";
        public Collection<String> loaders;
        @SerializedName(value="game_versions")
        public Collection<String> gameVersions;

        public LatestVersionsFromHashesBody(Collection<String> hashes, Collection<String> loaders, String mcVersion) {
            this.hashes = hashes;
            this.loaders = loaders;
            this.gameVersions = Set.of(mcVersion);
        }
    }
}

