/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.extraorigins.client.event;

import io.github.apace100.apoli.component.PowerHolderComponent;
import java.util.List;
import moriyashiine.extraorigins.common.packet.ChangeRadialDirectionPacket;
import moriyashiine.extraorigins.common.power.RadialMenuPower;
import moriyashiine.extraorigins.common.util.RadialMenuDirection;
import moriyashiine.extraorigins.mixin.radialmenu.client.ApoliClientAccessor;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;

public class RadialMenuEvents {
    public static boolean directionChanged = false;
    private static List<RadialMenuPower> activePowers;
    private static RadialMenuPower lastUsedPower;
    private static RadialMenuDirection targetDirection;
    private static boolean renderModeSwitch;
    private static int timer;

    public static void init() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            activePowers = null;
            lastUsedPower = null;
            directionChanged = false;
            targetDirection = null;
            renderModeSwitch = false;
            timer = 0;
        });
        ClientTickEvents.END_CLIENT_TICK.register((Object)new ClientTickEvents.EndTick(){

            public void onEndTick(class_310 client) {
                if (client.field_1755 != null) {
                    return;
                }
                activePowers = PowerHolderComponent.getPowers((class_1297)client.field_1724, RadialMenuPower.class).stream().filter(power -> ApoliClientAccessor.extraorigins$idToKeybindingMap().containsKey(power.getKey().key) && ApoliClientAccessor.extraorigins$idToKeybindingMap().get(power.getKey().key).method_1434()).toList();
                if (!activePowers.isEmpty()) {
                    client.field_1729.method_1610();
                    this.changeTargetMode(client);
                    this.handleModeChange();
                    renderModeSwitch = true;
                } else {
                    client.field_1729.method_1612();
                    lastUsedPower = null;
                    directionChanged = false;
                    targetDirection = null;
                    renderModeSwitch = false;
                    timer = 0;
                }
            }

            private void changeTargetMode(class_310 client) {
                RadialMenuDirection direction = null;
                boolean arrowKey = false;
                if (class_3675.method_15987((long)client.method_22683().method_4490(), (int)265)) {
                    direction = RadialMenuDirection.UP;
                    arrowKey = true;
                } else if (class_3675.method_15987((long)client.method_22683().method_4490(), (int)264)) {
                    direction = RadialMenuDirection.DOWN;
                    arrowKey = true;
                } else if (class_3675.method_15987((long)client.method_22683().method_4490(), (int)263)) {
                    direction = RadialMenuDirection.LEFT;
                    arrowKey = true;
                } else if (class_3675.method_15987((long)client.method_22683().method_4490(), (int)262)) {
                    direction = RadialMenuDirection.RIGHT;
                    arrowKey = true;
                }
                if (!arrowKey) {
                    double x = client.field_1729.method_1603() - (double)((float)client.method_22683().method_4480() / 2.0f);
                    double y = (double)((float)client.method_22683().method_4507() / 2.0f) - client.field_1729.method_1604();
                    if (Math.abs(x) > 48.0 || Math.abs(y) > 48.0) {
                        switch (class_2350.method_10142((double)x, (double)y, (double)0.0)) {
                            case field_11036: {
                                RadialMenuDirection radialMenuDirection = RadialMenuDirection.UP;
                                break;
                            }
                            case field_11033: {
                                RadialMenuDirection radialMenuDirection = RadialMenuDirection.DOWN;
                                break;
                            }
                            case field_11039: {
                                RadialMenuDirection radialMenuDirection = RadialMenuDirection.LEFT;
                                break;
                            }
                            case field_11034: {
                                RadialMenuDirection radialMenuDirection = RadialMenuDirection.RIGHT;
                                break;
                            }
                            default: {
                                RadialMenuDirection radialMenuDirection = direction = null;
                            }
                        }
                    }
                }
                if (targetDirection != direction) {
                    targetDirection = direction;
                    timer = 0;
                }
            }

            private void handleModeChange() {
                if (activePowers.get(0) != lastUsedPower) {
                    timer = 0;
                    lastUsedPower = activePowers.get(0);
                }
                if (targetDirection != null && lastUsedPower.getDirection() != targetDirection && lastUsedPower.getActionFromDirection(targetDirection) != null) {
                    if (!directionChanged) {
                        ++timer;
                    }
                    if (timer == RadialMenuEvents.lastUsedPower.swapTime) {
                        directionChanged = true;
                        timer = 0;
                        ChangeRadialDirectionPacket.send(targetDirection, lastUsedPower.getType());
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((Object)new HudRenderCallback(){

            public void onHudRender(class_332 drawContext, float tickDelta) {
                if (!renderModeSwitch) {
                    return;
                }
                class_1041 window = class_310.method_1551().method_22683();
                drawContext.method_25290(RadialMenuEvents.lastUsedPower.spriteLocation, window.method_4486() / 2 - 64, window.method_4502() / 2 - 64, 0.0f, 0.0f, 128, 128, 320, 256);
                this.renderSection(RadialMenuDirection.UP, drawContext, window, -32, -80, 0);
                this.renderSection(RadialMenuDirection.DOWN, drawContext, window, -32, 16, 64);
                this.renderSection(RadialMenuDirection.LEFT, drawContext, window, -80, -32, 128);
                this.renderSection(RadialMenuDirection.RIGHT, drawContext, window, 16, -32, 192);
                if (timer > 0) {
                    drawContext.method_25290(RadialMenuEvents.lastUsedPower.spriteLocation, window.method_4486() / 2 - 13, window.method_4502() / 2 - 13, 48.0f, 128.0f, 26, 26, 320, 256);
                    drawContext.method_25290(RadialMenuEvents.lastUsedPower.spriteLocation, window.method_4486() / 2 - 12, window.method_4502() / 2 - 12, 24.0f, 128.0f, 24, 24, 320, 256);
                    drawContext.method_25290(RadialMenuEvents.lastUsedPower.spriteLocation, window.method_4486() / 2 - 12, window.method_4502() / 2 - 12, 0.0f, 128.0f, 24, (int)(24.0f - 24.0f * ((float)(timer + 1) / (float)RadialMenuEvents.lastUsedPower.swapTime)), 320, 256);
                }
            }

            private void renderSection(RadialMenuDirection targetMode, class_332 drawContext, class_1041 window, int posXOffset, int posYOffset, int v) {
                if (lastUsedPower.getActionFromDirection(targetMode) == null) {
                    return;
                }
                int u = 128;
                if (lastUsedPower.getDirection() == targetMode) {
                    u += 128;
                } else if (targetDirection == targetMode) {
                    u += 64;
                }
                drawContext.method_25290(RadialMenuEvents.lastUsedPower.spriteLocation, window.method_4486() / 2 + posXOffset, window.method_4502() / 2 + posYOffset, (float)u, (float)v, 64, 64, 320, 256);
            }
        });
    }

    static {
        targetDirection = null;
        renderModeSwitch = false;
        timer = 0;
    }
}

