/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.library.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTransformCategoryExtension;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTrimCategoryExtension;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostableRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.BlastingCategory;
import mezz.jei.library.plugins.vanilla.cooking.CampfireCookingCategory;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceSmeltingCategory;
import mezz.jei.library.plugins.vanilla.cooking.SmokingCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FurnaceFuelCategory;
import mezz.jei.library.plugins.vanilla.crafting.CraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShieldDecorationRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShulkerBoxColoringRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.SuspiciousStewRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.TippedArrowRecipeMaker;
import mezz.jei.library.plugins.vanilla.gui.InventoryEffectRendererGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.RecipeBookGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.ToastGuiHandler;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.FireworkRocketSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.InstrumentSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.LightSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PaintingSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.SuspiciousStewSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.stonecutting.StoneCuttingRecipeCategory;
import mezz.jei.library.render.FluidTankRenderer;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.transfer.PlayerRecipeTransferHandler;
import net.minecraft.class_1706;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1871;
import net.minecraft.class_1872;
import net.minecraft.class_1873;
import net.minecraft.class_1876;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3858;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3917;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_479;
import net.minecraft.class_485;
import net.minecraft.class_4862;
import net.minecraft.class_489;
import net.minecraft.class_4895;
import net.minecraft.class_490;
import net.minecraft.class_7924;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class VanillaPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private CraftingRecipeCategory craftingCategory;
    @Nullable
    private IRecipeCategory<class_3975> stonecuttingCategory;
    @Nullable
    private IRecipeCategory<class_3861> furnaceCategory;
    @Nullable
    private IRecipeCategory<class_3862> smokingCategory;
    @Nullable
    private IRecipeCategory<class_3859> blastingCategory;
    @Nullable
    private IRecipeCategory<class_3920> campfireCategory;
    @Nullable
    private SmithingRecipeCategory smithingCategory;

    @Override
    public class_2960 getPluginUid() {
        return new class_2960("jei", "minecraft");
    }

    @Override
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(class_1802.field_8087, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8574, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8436, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8150, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8598, EnchantedBookSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_30904, LightSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8892, PaintingSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_39057, InstrumentSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8639, FireworkRocketSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(class_1802.field_8766, SuspiciousStewSubtypeInterpreter.INSTANCE);
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        StackHelper stackHelper = new StackHelper(subtypeManager);
        List<class_1799> itemStacks = ItemStackListFactory.create(stackHelper);
        IColorHelper colorHelper = registration.getColorHelper();
        ItemStackHelper itemStackHelper = new ItemStackHelper(subtypeManager, stackHelper, colorHelper);
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer();
        registration.register(VanillaTypes.ITEM_STACK, itemStacks, itemStackHelper, itemStackRenderer);
        IPlatformFluidHelperInternal<?> platformFluidHelper = Services.PLATFORM.getFluidHelper();
        this.registerFluidIngredients(registration, platformFluidHelper);
    }

    private <T> void registerFluidIngredients(IModIngredientRegistration registration, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        IColorHelper colorHelper = registration.getColorHelper();
        IPlatformRegistry<class_3611> registry = Services.PLATFORM.getRegistry(class_7924.field_41270);
        List<T> fluidIngredients = FluidStackListFactory.create(registry, platformFluidHelper);
        FluidIngredientHelper<T> fluidIngredientHelper = new FluidIngredientHelper<T>(subtypeManager, colorHelper, platformFluidHelper);
        FluidTankRenderer<T> fluidTankRenderer = new FluidTankRenderer<T>(platformFluidHelper);
        IIngredientTypeWithSubtypes fluidIngredientType = platformFluidHelper.getFluidIngredientType();
        registration.register(fluidIngredientType, fluidIngredients, fluidIngredientHelper, fluidTankRenderer);
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        Textures textures = Internal.getTextures();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[11];
        this.craftingCategory = new CraftingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.craftingCategory;
        this.stonecuttingCategory = new StoneCuttingRecipeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.stonecuttingCategory;
        this.furnaceCategory = new FurnaceSmeltingCategory(guiHelper);
        iRecipeCategoryArray[2] = this.furnaceCategory;
        this.smokingCategory = new SmokingCategory(guiHelper);
        iRecipeCategoryArray[3] = this.smokingCategory;
        this.blastingCategory = new BlastingCategory(guiHelper);
        iRecipeCategoryArray[4] = this.blastingCategory;
        this.campfireCategory = new CampfireCookingCategory(guiHelper);
        iRecipeCategoryArray[5] = this.campfireCategory;
        this.smithingCategory = new SmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[6] = this.smithingCategory;
        iRecipeCategoryArray[7] = new CompostableRecipeCategory(guiHelper);
        iRecipeCategoryArray[8] = new FurnaceFuelCategory(textures);
        iRecipeCategoryArray[9] = new BrewingRecipeCategory(guiHelper);
        iRecipeCategoryArray[10] = new AnvilRecipeCategory(guiHelper);
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    @Override
    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory<class_3955, ICraftingCategoryExtension> craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(class_3955.class, r -> !r.method_8118(), CraftingCategoryExtension::new);
        IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        smithingCategory.addExtension(class_8060.class, new SmithingTransformCategoryExtension(recipeHelper));
        smithingCategory.addExtension(class_8062.class, new SmithingTrimCategoryExtension(recipeHelper));
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.craftingCategory, "craftingCategory");
        ErrorUtil.checkNotNull(this.stonecuttingCategory, "stonecuttingCategory");
        ErrorUtil.checkNotNull(this.furnaceCategory, "furnaceCategory");
        ErrorUtil.checkNotNull(this.smokingCategory, "smokingCategory");
        ErrorUtil.checkNotNull(this.blastingCategory, "blastingCategory");
        ErrorUtil.checkNotNull(this.campfireCategory, "campfireCategory");
        ErrorUtil.checkNotNull(this.smithingCategory, "smithingCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        VanillaRecipes vanillaRecipes = new VanillaRecipes(ingredientManager);
        Map<Boolean, List<class_3955>> craftingRecipes = vanillaRecipes.getCraftingRecipes(this.craftingCategory);
        List<class_3955> handledCraftingRecipes = craftingRecipes.get(true);
        List<class_3955> unhandledCraftingRecipes = craftingRecipes.get(false);
        List<class_3955> specialCraftingRecipes = VanillaPlugin.replaceSpecialCraftingRecipes(unhandledCraftingRecipes, stackHelper);
        registration.addRecipes(RecipeTypes.CRAFTING, handledCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);
        registration.addRecipes(RecipeTypes.STONECUTTING, vanillaRecipes.getStonecuttingRecipes(this.stonecuttingCategory));
        registration.addRecipes(RecipeTypes.SMELTING, vanillaRecipes.getFurnaceRecipes(this.furnaceCategory));
        registration.addRecipes(RecipeTypes.SMOKING, vanillaRecipes.getSmokingRecipes(this.smokingCategory));
        registration.addRecipes(RecipeTypes.BLASTING, vanillaRecipes.getBlastingRecipes(this.blastingCategory));
        registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, vanillaRecipes.getCampfireCookingRecipes(this.campfireCategory));
        registration.addRecipes(RecipeTypes.FUELING, FuelRecipeMaker.getFuelRecipes(ingredientManager));
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientManager));
        registration.addRecipes(RecipeTypes.SMITHING, vanillaRecipes.getSmithingRecipes(this.smithingCategory));
        registration.addRecipes(RecipeTypes.COMPOSTING, CompostingRecipeMaker.getRecipes(ingredientManager));
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        List<IJeiBrewingRecipe> brewingRecipes = recipeHelper.getBrewingRecipes(ingredientManager, vanillaRecipeFactory);
        brewingRecipes.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(class_479.class, 88, 32, 28, 23, RecipeTypes.CRAFTING);
        registration.addRecipeClickArea(class_490.class, 137, 29, 10, 13, RecipeTypes.CRAFTING);
        registration.addRecipeClickArea(class_472.class, 97, 16, 14, 30, RecipeTypes.BREWING);
        registration.addRecipeClickArea(class_3873.class, 78, 32, 28, 23, RecipeTypes.SMELTING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(class_3874.class, 78, 32, 28, 23, RecipeTypes.SMOKING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(class_3871.class, 78, 32, 28, 23, RecipeTypes.BLASTING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(class_471.class, 102, 48, 22, 15, RecipeTypes.ANVIL);
        registration.addRecipeClickArea(class_4895.class, 68, 49, 22, 15, RecipeTypes.SMITHING);
        registration.addGenericGuiContainerHandler(class_485.class, new InventoryEffectRendererGuiHandler());
        registration.addGuiContainerHandler(class_479.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(class_490.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(class_489.class, new RecipeBookGuiHandler());
        registration.addGlobalGuiHandler(new ToastGuiHandler());
    }

    @Override
    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(class_1714.class, class_3917.field_17333, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(class_3858.class, class_3917.field_17335, RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(class_3858.class, class_3917.field_17335, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(class_3706.class, class_3917.field_17342, RecipeTypes.SMOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(class_3706.class, class_3917.field_17342, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(class_3705.class, class_3917.field_17331, RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(class_3705.class, class_3917.field_17331, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(class_1708.class, class_3917.field_17332, RecipeTypes.BREWING, 0, 4, 5, 36);
        registration.addRecipeTransferHandler(class_1706.class, class_3917.field_17329, RecipeTypes.ANVIL, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(class_4862.class, class_3917.field_22484, RecipeTypes.SMITHING, 0, 3, 3, 36);
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        PlayerRecipeTransferHandler recipeTransferHandler = new PlayerRecipeTransferHandler(transferHelper);
        registration.addRecipeTransferHandler(recipeTransferHandler, RecipeTypes.CRAFTING);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalysts(RecipeTypes.CRAFTING, new class_1935[]{class_2246.field_9980});
        registration.addRecipeCatalysts(RecipeTypes.FUELING, new class_1935[]{class_2246.field_10181, class_2246.field_16334, class_2246.field_16333});
        registration.addRecipeCatalysts(RecipeTypes.CAMPFIRE_COOKING, new class_1935[]{class_2246.field_17350, class_2246.field_23860});
        registration.addRecipeCatalyst((class_1935)class_2246.field_16335, RecipeTypes.STONECUTTING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_10181, RecipeTypes.SMELTING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_16334, RecipeTypes.SMOKING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_16333, RecipeTypes.BLASTING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_10333, RecipeTypes.BREWING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_10535, RecipeTypes.ANVIL);
        registration.addRecipeCatalyst((class_1935)class_2246.field_16329, RecipeTypes.SMITHING);
        registration.addRecipeCatalyst((class_1935)class_2246.field_17563, RecipeTypes.COMPOSTING);
    }

    public Optional<CraftingRecipeCategory> getCraftingCategory() {
        return Optional.ofNullable(this.craftingCategory);
    }

    public Optional<SmithingRecipeCategory> getSmithingCategory() {
        return Optional.ofNullable(this.smithingCategory);
    }

    private static List<class_3955> replaceSpecialCraftingRecipes(List<class_3955> unhandledCraftingRecipes, IStackHelper stackHelper) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(class_1876.class, () -> TippedArrowRecipeMaker.createRecipes(stackHelper));
        replacers.put(class_1871.class, ShulkerBoxColoringRecipeMaker::createRecipes);
        replacers.put(class_1873.class, SuspiciousStewRecipeMaker::createRecipes);
        replacers.put(class_1872.class, ShieldDecorationRecipeMaker::createRecipes);
        return unhandledCraftingRecipes.stream().map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to create JEI recipes for {}", recipeClass, (Object)e);
                return Stream.of(new class_3955[0]);
            }
        }).toList();
    }
}

