/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class ReinforcementsTrait<E extends class_1309>
extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("reinforcements");
    public static final MapCodec<ReinforcementsTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("range", (Object)32).forGetter(o -> o.range), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("reinforcements", new ArrayList()).forGetter(o -> o.reinforcementTypes.stream().map(arg_0 -> Walkers.getEntityTypeRegistry().method_10221(arg_0)).toList()), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("reinforcement_tags", new ArrayList()).forGetter(o -> o.reinforcementTags.stream().map(class_6862::comp_327).toList())).apply((Applicative)instance, instance.stable((range, reinforcementsLocations, reinforcementTagsLocations) -> {
        ArrayList reinforcements = new ArrayList();
        ArrayList reinforcementTags = new ArrayList();
        for (class_2960 resourceLocation : reinforcementsLocations) {
            if (!Walkers.getEntityTypeRegistry().method_10250(resourceLocation)) continue;
            reinforcements.add((class_1299)Walkers.getEntityTypeRegistry().method_10223(resourceLocation));
        }
        for (class_2960 resourceLocation : reinforcementTagsLocations) {
            reinforcementTags.add(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)resourceLocation));
        }
        return new ReinforcementsTrait((int)range, reinforcements, reinforcementTags);
    })));
    private final int range;
    private final List<class_1299<?>> reinforcementTypes;
    private final List<class_6862<class_1299<?>>> reinforcementTags;

    public ReinforcementsTrait() {
        this(32);
    }

    public ReinforcementsTrait(int range) {
        this(range, new ArrayList());
    }

    public ReinforcementsTrait(List<class_1299<?>> reinforcementTypes) {
        this(32, reinforcementTypes);
    }

    public ReinforcementsTrait(int range, @NotNull List<class_1299<?>> reinforcementTypes) {
        this(range, reinforcementTypes, new ArrayList());
    }

    public ReinforcementsTrait(int range, @NotNull List<class_1299<?>> reinforcementTypes, @NotNull List<class_6862<class_1299<?>>> reinforcementTags) {
        this.range = range;
        this.reinforcementTypes = reinforcementTypes;
        this.reinforcementTags = reinforcementTags;
    }

    public boolean hasReinforcements() {
        return !this.reinforcementTypes.isEmpty() || !this.reinforcementTags.isEmpty();
    }

    public boolean isReinforcement(class_1297 entity) {
        if (this.reinforcementTypes.contains(entity.method_5864())) {
            return true;
        }
        for (class_6862<class_1299<?>> reinforcementTag : this.reinforcementTags) {
            if (!entity.method_5864().method_20210(reinforcementTag)) continue;
            return true;
        }
        return false;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_1058 getIcon() {
        class_1087 itemModel = class_310.method_1551().method_1480().method_4012().method_3304(class_1802.field_8371);
        if (itemModel != null) {
            return itemModel.method_4711();
        }
        return super.getIcon();
    }
}

