/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.actions.bientity;

import com.provismet.proviorigins.powers.Powers;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3545;

public class FireProjectileAction {
    private static final String SPEED_LABEL = "speed";
    private static final String ENTITY_LABEL = "entity_type";
    private static final String NBT_LABEL = "tag";
    private static final String DIVERGENCE_LABEL = "divergence";

    public static void action(SerializableData.Instance data, class_3545<class_1297, class_1297> pair) {
        if (((class_1297)pair.method_15442()).method_37908().method_8608()) {
            return;
        }
        class_1297 actor = (class_1297)pair.method_15442();
        class_1297 target = (class_1297)pair.method_15441();
        class_3218 serverWorld = (class_3218)actor.method_37908();
        int count = data.getInt("count");
        float speed = data.getFloat(SPEED_LABEL);
        float divergence = data.getFloat(DIVERGENCE_LABEL);
        class_1299 entityType = (class_1299)data.get(ENTITY_LABEL);
        class_2487 entityNbt = (class_2487)data.get(NBT_LABEL);
        double dx = target.method_23317() - actor.method_23317();
        double dy = target.method_23320() - actor.method_23320();
        double dz = target.method_23321() - actor.method_23321();
        class_243 projectileDirection = new class_243(dx, dy, dz).method_1029();
        for (int i = 0; i < count; ++i) {
            Optional opt$entityToSpawn = MiscUtil.getEntityWithPassengers((class_1937)serverWorld, (class_1299)entityType, (class_2487)entityNbt, (class_243)actor.method_19538().method_1031(0.0, (double)actor.method_18381(actor.method_18376()), 0.0), (float)actor.method_36454(), (float)actor.method_36455());
            if (opt$entityToSpawn.isEmpty()) {
                return;
            }
            class_1297 entityToSpawn = (class_1297)opt$entityToSpawn.get();
            if (entityToSpawn instanceof class_1676) {
                class_1676 projectileToSpawn = (class_1676)entityToSpawn;
                if (projectileToSpawn instanceof class_1668) {
                    class_1668 explosiveProjectileToSpawn = (class_1668)projectileToSpawn;
                    explosiveProjectileToSpawn.field_7601 = projectileDirection.field_1352 * (double)speed;
                    explosiveProjectileToSpawn.field_7600 = projectileDirection.field_1351 * (double)speed;
                    explosiveProjectileToSpawn.field_7599 = projectileDirection.field_1350 * (double)speed;
                }
                projectileToSpawn.method_7432(actor);
                projectileToSpawn.method_7485(projectileDirection.field_1352, projectileDirection.field_1351, projectileDirection.field_1350, speed, divergence);
            } else {
                class_243 velocity = projectileDirection.method_1021((double)speed);
                entityToSpawn.method_18799(velocity);
            }
            serverWorld.method_30736(entityToSpawn);
            data.ifPresent("projectile_action", projectileAction -> projectileAction.accept(entityToSpawn));
        }
    }

    public static ActionFactory<class_3545<class_1297, class_1297>> createBientityActionFactory() {
        return new ActionFactory(Powers.identifier("fire_projectile"), new SerializableData().add(ENTITY_LABEL, SerializableDataTypes.ENTITY_TYPE).add(DIVERGENCE_LABEL, SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add(SPEED_LABEL, SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("count", SerializableDataTypes.INT, (Object)1).add(NBT_LABEL, SerializableDataTypes.NBT, null).add("projectile_action", ApoliDataTypes.ENTITY_ACTION, null), FireProjectileAction::action);
    }
}

