/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.content.entities;

import com.provismet.proviorigins.extras.ExtraTameable;
import com.provismet.proviorigins.extras.Temporary;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1380;
import net.minecraft.class_1383;
import net.minecraft.class_1399;
import net.minecraft.class_1405;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3321;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6025;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CloneEntity
extends class_1588
implements ExtraTameable,
class_3745,
Temporary {
    private static final double COMBAT_SPEED = 1.35;
    private static final float SHOOTING_RANGE = 32.0f;
    private boolean canSit;
    private boolean followOwner;
    private boolean canAttack;
    private int maxTicks;
    private final class_1366 MELEE_ATTACK = new class_1366((class_1314)this, 1.35, false);
    private final class_1380<CloneEntity> RANGED_ATTACK = new class_1380((class_1588)this, 1.35, 20, 32.0f);
    private final class_1383<CloneEntity> CROSSBOW_ATTACK = new class_1383((class_1588)this, 1.35, 32.0f);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(CloneEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(CloneEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(CloneEntity.class, (class_2941)class_2943.field_13323);

    public CloneEntity(class_1299<? extends CloneEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.updateWeaponGoals();
        this.field_6194 = 0;
        this.maxTicks = 1200;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityNbt) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        this.updateWeaponGoals();
        this.method_5952(false);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_270 team;
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.method_5781() == null && this.getOwner() != null && this.getOwner().method_5781() != null && (team = this.getOwner().method_5781()) instanceof class_268) {
                class_268 implementedTeam = (class_268)team;
                serverWorld.method_14170().method_1172(this.method_5845(), implementedTeam);
            }
        }
        return data;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(CHARGING, (Object)false);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new FollowOwnerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1429.class, 16.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new DefendOwnerGoal(this));
        this.field_6185.method_6277(1, (class_1352)new FightForOwnerGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createCloneAttributes() {
        class_5132.class_5133 attributes = class_1588.method_26828();
        attributes.method_26867(class_5134.field_23721);
        attributes.method_26868(class_5134.field_23716, 20.0);
        attributes.method_26868(class_5134.field_23719, (double)0.35f);
        attributes.method_26868(class_5134.field_23717, 64.0);
        return attributes;
    }

    protected boolean method_23734() {
        return false;
    }

    public class_3419 method_5634() {
        return class_3419.field_15248;
    }

    public boolean method_5939(class_1799 stack) {
        return false;
    }

    public boolean method_5733() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.getOwner() == null || this.getOwner().method_37908().method_27983() != this.method_37908().method_27983() || this.field_6012 > this.maxTicks && this.maxTicks > 0) {
            this.method_31472();
        } else if (this.field_6012 == this.maxTicks - 1) {
            for (int i = 0; i < 20; ++i) {
                double velX = this.field_5974.method_43059() * 0.02;
                double velY = this.field_5974.method_43059() * 0.02;
                double velZ = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), velX, velY, velZ);
            }
        }
    }

    @Override
    public boolean isOwned() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).isPresent();
    }

    @Override
    public void setOwnerUUID(@Nullable UUID uuid) {
        if (uuid == null) {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(uuid));
        }
    }

    @Override
    public void setOwner(@Nullable class_1309 owner) {
        if (!(owner instanceof class_1657)) {
            return;
        }
        ExtraTameable.super.setOwner(owner);
    }

    @Nullable
    public UUID method_6139() {
        Optional uuid = (Optional)this.field_6011.method_12789(OWNER_UUID);
        return uuid.orElse(null);
    }

    @Nullable
    public class_1657 getOwner() {
        UUID uuid = this.method_6139();
        if (uuid == null) {
            return null;
        }
        return this.method_37908().method_18470(uuid);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.method_24518(class_1802.field_8399)) {
            this.method_24654((class_1309)this, 1.6f);
            return;
        }
        class_1799 arrowType = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102)));
        class_1665 persistentProjectileEntity = class_1675.method_18813((class_1309)this, (class_1799)arrowType, (float)pullProgress);
        persistentProjectileEntity.field_7572 = class_1665.class_1666.field_7592;
        double xDirection = target.method_23317() - this.method_23317();
        double yDirection = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
        double zDirection = target.method_23321() - this.method_23321();
        double g = Math.sqrt(xDirection * xDirection + zDirection * zDirection);
        persistentProjectileEntity.method_7485(xDirection, yDirection + g * (double)0.2f, zDirection, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (this.method_37908().method_8409().method_43057() * 0.4f + 1.2f) + pullProgress * 0.5f);
        this.method_37908().method_8649((class_1297)persistentProjectileEntity);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void method_7110(boolean isCharging) {
        this.field_6011.method_12778(CHARGING, (Object)isCharging);
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        projectile.method_7432((class_1297)this.getOwner());
        if (projectile instanceof class_1665) {
            class_1665 persistent = (class_1665)projectile;
            persistent.field_7572 = class_1665.class_1666.field_7592;
        }
        this.method_24652((class_1309)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void method_24651() {
    }

    public void updateWeaponGoals() {
        boolean WEAPON_GOAL_PRIORITY = true;
        if (this.method_37908() == null || this.method_37908().method_8608()) {
            return;
        }
        this.field_6201.method_6280((class_1352)this.MELEE_ATTACK);
        this.field_6201.method_6280(this.RANGED_ATTACK);
        this.field_6201.method_6280(this.CROSSBOW_ATTACK);
        if (this.method_24518(class_1802.field_8102)) {
            this.field_6201.method_6277(1, this.RANGED_ATTACK);
        } else if (this.method_24518(class_1802.field_8399)) {
            this.field_6201.method_6277(1, this.CROSSBOW_ATTACK);
        } else {
            this.field_6201.method_6277(1, (class_1352)this.MELEE_ATTACK);
        }
    }

    public void method_5749(class_2487 nbt) {
        UUID uuid;
        super.method_5749(nbt);
        this.updateWeaponGoals();
        if (nbt.method_25928("Owner")) {
            uuid = nbt.method_25926("Owner");
        } else {
            String ownerName = nbt.method_10558("Owner");
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)ownerName);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.isOwned()) {
            nbt.method_25927("Owner", this.method_6139());
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player == this.getOwner()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_5812;
            }
            if (this.canSit) {
                this.toggleSitting();
                return class_1269.method_29236((boolean)false);
            }
        }
        return class_1269.field_5811;
    }

    protected class_1665 createArrowProjectile(class_1799 arrow, float damageModifier) {
        class_1665 projectile = class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)damageModifier);
        projectile.field_7572 = class_1665.class_1666.field_7592;
        return projectile;
    }

    public class_1310 method_6046() {
        if (this.getOwner() != null) {
            return this.getOwner().method_6046();
        }
        return super.method_6046();
    }

    public boolean method_18395(class_1309 target) {
        if (this.getOwner() == null || !target.method_33190() || target == this.getOwner() || this.isSitting() || !this.canAttack || this.method_5781() != null && target.method_5781() != null && this.method_5781().method_1206(target.method_5781())) {
            return false;
        }
        if (target instanceof class_6025) {
            class_6025 tameable = (class_6025)target;
            return tameable.method_35057() != this.getOwner();
        }
        return true;
    }

    public void setCanSit(boolean value) {
        this.canSit = value;
    }

    public void setFollowOwner(boolean value) {
        this.followOwner = value;
    }

    public void setCanAttack(boolean value) {
        this.canAttack = value;
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void toggleSitting() {
        this.field_6011.method_12778(SITTING, (Object)(!this.isSitting() ? 1 : 0));
    }

    public void setSitting(boolean isSat) {
        this.field_6011.method_12778(SITTING, (Object)isSat);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    @Override
    public void setMaxLifetime(int ticks) {
        this.maxTicks = ticks;
    }

    public boolean method_5822() {
        return false;
    }

    protected static class FollowOwnerGoal
    extends CloneGoal {
        private static final double MAX_DISTANCE = 32.0;
        private static final double MIN_DISTANCE = 6.0;
        private final double speed;
        private int tickTimer = 0;

        public FollowOwnerGoal(CloneEntity clone, double speed) {
            super(clone);
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public FollowOwnerGoal(CloneEntity clone) {
            this(clone, 1.0);
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && this.clone.followOwner && (double)this.clone.method_5739((class_1297)this.owner) >= 32.0;
        }

        public void method_6269() {
            this.clone.method_5942().method_6335((class_1297)this.owner, this.speed);
        }

        public void method_6270() {
            this.clone.method_5942().method_6340();
        }

        public boolean method_6266() {
            return super.method_6264() && (double)this.clone.method_5739((class_1297)this.owner) >= 6.0;
        }

        public void method_6268() {
            this.clone.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.clone.method_5978());
            if (this.clone.method_5934() || this.clone.method_5765() || --this.tickTimer > 0) {
                return;
            }
            this.tickTimer = this.method_38847(10);
            this.clone.method_5942().method_6335((class_1297)this.owner, this.speed);
        }
    }

    protected static class DefendOwnerGoal
    extends AssistOwnerGoal {
        public DefendOwnerGoal(CloneEntity clone) {
            super(clone);
        }

        @Override
        public boolean method_6264() {
            if (super.method_6264() && this.owner.method_6065() != null && this.clone.method_18395(this.owner.method_6065()) && this.timer != this.owner.method_6117()) {
                this.field_6664 = this.owner.method_6065();
                this.timer = this.owner.method_6117();
                return true;
            }
            return false;
        }
    }

    protected static class FightForOwnerGoal
    extends AssistOwnerGoal {
        public FightForOwnerGoal(CloneEntity clone) {
            super(clone);
        }

        @Override
        public boolean method_6264() {
            if (super.method_6264() && this.owner.method_6052() != null && this.clone.method_18395(this.owner.method_6052()) && this.timer != this.owner.method_6083()) {
                this.field_6664 = this.owner.method_6052();
                this.timer = this.owner.method_6083();
                return true;
            }
            return false;
        }
    }

    protected static abstract class AssistOwnerGoal
    extends class_1405 {
        protected final CloneEntity clone;
        protected class_1657 owner;
        protected int timer = 0;

        protected AssistOwnerGoal(CloneEntity clone) {
            super((class_1308)clone, false);
            this.clone = clone;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.owner == null) {
                this.owner = this.clone.getOwner();
            }
            return this.owner != null && !this.clone.isSitting() && this.clone.canAttack;
        }
    }

    protected static abstract class CloneGoal
    extends class_1352 {
        protected final CloneEntity clone;
        protected class_1657 owner;

        protected CloneGoal(CloneEntity clone) {
            this.clone = clone;
        }

        public boolean method_6264() {
            if (this.owner == null) {
                this.owner = this.clone.getOwner();
            }
            return !this.clone.isSitting() && this.owner != null;
        }
    }
}

