/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.mixin;

import com.google.common.collect.ImmutableMap;
import com.provismet.proviorigins.content.entities.CloneEntity;
import com.provismet.proviorigins.content.entities.renderers.CloneEntityRenderer;
import com.provismet.proviorigins.content.registries.POEntities;
import com.provismet.proviorigins.mixin.LivingEntityRendererAccessor;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.impl.client.rendering.RegistrationHelperImpl;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_759;
import net.minecraft.class_776;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    @Final
    private class_918 field_27759;
    @Shadow
    @Final
    private class_327 field_4689;
    @Shadow
    @Final
    private class_5599 field_27760;
    @Shadow
    @Final
    private class_759 field_38887;
    @Shadow
    @Final
    private class_776 field_38886;
    @Unique
    private Map<String, class_897<CloneEntity>> cloneRenderers = ImmutableMap.of();

    @Inject(at={@At(value="HEAD")}, method={"getRenderer"}, cancellable=true)
    public <T extends class_1297> void getCloneRenderer(T entity, CallbackInfoReturnable<class_897<? super T>> cir) {
        if (entity instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)entity;
            if (clone.isOwned()) {
                try {
                    String modelType = class_310.method_1551().method_1562().method_2871(clone.method_6139()).method_2977();
                    class_897<CloneEntity> renderer = this.cloneRenderers.get(modelType);
                    cir.setReturnValue(renderer);
                }
                catch (NullPointerException e) {
                    cir.setReturnValue(this.cloneRenderers.get("default"));
                }
            } else {
                cir.setReturnValue(this.cloneRenderers.get("default"));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"reload"})
    public void reload(class_3300 manager, CallbackInfo info) {
        class_5617.class_5618 context = new class_5617.class_5618((class_898)this, this.field_27759, this.field_38886, this.field_38887, manager, this.field_27760, this.field_4689);
        this.cloneRenderers = ImmutableMap.of((Object)"default", EntityRenderDispatcherMixin.createCloneEntityRenderer(context, false), (Object)"slim", EntityRenderDispatcherMixin.createCloneEntityRenderer(context, true));
    }

    @Unique
    private static CloneEntityRenderer<CloneEntity> createCloneEntityRenderer(class_5617.class_5618 context, boolean slimArms) {
        CloneEntityRenderer<CloneEntity> renderer = new CloneEntityRenderer<CloneEntity>(context, slimArms);
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)((Object)renderer);
        ((LivingEntityFeatureRendererRegistrationCallback)LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker()).registerRenderers(POEntities.CLONE, renderer, (LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper)new RegistrationHelperImpl(accessor::invokeAddFeature), context);
        return renderer;
    }
}

