/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.proviorigins.powers;

import com.provismet.proviorigins.powers.Powers;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class ActiveItemPower
extends ActiveCooldownPower {
    private final Consumer<class_1297> entityAction;
    private final Predicate<class_1799> itemCondition;
    private final Predicate<class_1297> consumeCondition;
    private final int consumeAmount;
    private final boolean shouldSwingArm;

    public ActiveItemPower(PowerType<?> type, class_1309 entity, int cooldownDuration, HudRender hudRender, Consumer<class_1297> entityAction, Predicate<class_1799> itemCondition, Predicate<class_1297> consumeCondition, int consumeAmount, boolean shouldSwingArm) {
        super(type, entity, cooldownDuration, hudRender, entityAction);
        this.entityAction = entityAction;
        this.itemCondition = itemCondition;
        this.consumeCondition = consumeCondition;
        this.consumeAmount = consumeAmount;
        this.shouldSwingArm = shouldSwingArm;
    }

    public void onUse() {
        if (this.canUse()) {
            class_1799 mainhand = this.entity.method_6118(class_1304.field_6173);
            class_1799 offhand = this.entity.method_6118(class_1304.field_6171);
            if (this.itemCondition.test(mainhand) && mainhand.method_7947() >= this.consumeAmount) {
                this.perform(class_1268.field_5808, mainhand);
            } else if (this.itemCondition.test(offhand) && offhand.method_7947() >= this.consumeAmount) {
                List activeItemPowers = PowerHolderComponent.getPowers((class_1297)this.entity, ActiveItemPower.class);
                for (ActiveItemPower powerInstance : activeItemPowers) {
                    if (!powerInstance.itemCondition.test(mainhand) || !this.getKey().equals((Object)powerInstance.getKey())) continue;
                    return;
                }
                this.perform(class_1268.field_5810, offhand);
            }
        }
    }

    private void perform(class_1268 hand, class_1799 itemStack) {
        if (this.shouldSwingArm) {
            this.entity.method_23667(hand, true);
        }
        if (!(this.consumeCondition != null && !this.consumeCondition.test((class_1297)this.entity) || this.entity instanceof class_1657 && ((class_1657)this.entity).method_7337())) {
            itemStack.method_7934(this.consumeAmount);
        }
        this.use();
        this.entityAction.accept((class_1297)this.entity);
    }

    public static PowerFactory createPowerFactory() {
        return new PowerFactory(Powers.identifier("active_item"), new SerializableData().add("entity_action", ApoliDataTypes.ENTITY_ACTION).add("item_condition", ApoliDataTypes.ITEM_CONDITION).add("consume_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("consume_amount", SerializableDataTypes.INT, (Object)1).add("swing_arm", SerializableDataTypes.BOOLEAN, (Object)true).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> (type, player) -> {
            ActiveItemPower power = new ActiveItemPower((PowerType<?>)type, (class_1309)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Consumer)data.get("entity_action"), (Predicate)data.get("item_condition"), (Predicate)data.get("consume_condition"), data.getInt("consume_amount"), data.getBoolean("swing_arm"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }
}

