/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.common.worldgen.feature;

import com.mojang.serialization.Codec;
import com.obscuria.aquamirae.common.blocks.OxygeliumBlock;
import com.obscuria.aquamirae.registry.AquamiraeBlocks;
import java.util.List;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class OxygeliumFeature
extends class_3031<class_3111> {
    private final List<class_2248> BLOCKS = List.of(class_2246.field_10255);

    public OxygeliumFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        boolean flag2;
        int l;
        int xo = context.method_33655().method_10263() + context.method_33654().method_39332(-6, 6);
        int zo = context.method_33655().method_10260() + context.method_33654().method_39332(-6, 6);
        class_2338 mainPos = new class_2338(xo, context.method_33652().method_8624(class_2902.class_2903.field_13195, xo, zo) - 1, zo);
        if (!this.BLOCKS.contains(context.method_33652().method_8320(mainPos).method_26204())) {
            return false;
        }
        class_5281 worldAccess = context.method_33652();
        class_5819 random = context.method_33654();
        boolean flag = random.method_43058() > 0.7;
        class_2680 blockstate = class_2246.field_10340.method_9564();
        double d0 = random.method_43058() * 2.0 * Math.PI;
        int i = 11 - random.method_43048(5);
        int j = 3 + random.method_43048(3);
        boolean flag1 = random.method_43058() > 0.7;
        int n = l = flag1 ? random.method_43048(6) + 6 : random.method_43048(15) + 3;
        if (!flag1 && random.method_43058() > 0.9) {
            l += random.method_43048(19) + 7;
        }
        int i1 = Math.min(l + random.method_43048(11), 18);
        int j1 = Math.min(l + random.method_43048(7) - random.method_43048(5), 11);
        int k1 = flag1 ? i : 11;
        for (int l1 = -k1; l1 < k1; ++l1) {
            for (int i2 = -k1; i2 < k1; ++i2) {
                for (int j2 = 0; j2 < l; ++j2) {
                    int k2;
                    int n2 = k2 = flag1 ? this.heightDependentRadiusEllipse(j2, l, j1) : this.heightDependentRadiusRound(random, j2, l, j1);
                    if (!flag1 && l1 >= k2) continue;
                    this.generateIcebergBlock(worldAccess, random, mainPos, l, l1, j2, i2, k2, k1, flag1, j, d0, flag, blockstate);
                }
            }
        }
        this.smooth(worldAccess, mainPos, j1, l, flag1, i);
        for (int i3 = -k1; i3 < k1; ++i3) {
            for (int j3 = -k1; j3 < k1; ++j3) {
                for (int k3 = -1; k3 > -i1; --k3) {
                    int l3 = flag1 ? class_3532.method_15386((float)((float)k1 * (1.0f - (float)Math.pow(k3, 2.0) / ((float)i1 * 8.0f)))) : k1;
                    int l2 = this.heightDependentRadiusSteep(random, -k3, i1, j1);
                    if (i3 >= l2) continue;
                    this.generateIcebergBlock(worldAccess, random, mainPos, i1, i3, k3, j3, l2, l3, flag1, j, d0, flag, blockstate);
                }
            }
        }
        boolean bl = flag1 ? random.method_43058() > 0.1 : (flag2 = random.method_43058() > 0.7);
        if (flag2) {
            this.generateCutOut(random, worldAccess, j1, l, mainPos, flag1, i, d0, j);
        }
        int count = context.method_33654().method_39332(3, 13);
        for (int index = 0; index <= count; ++index) {
            int x = (int)((double)context.method_33655().method_10263() + context.method_33654().method_43385(0.0, 4.0));
            int z = (int)((double)context.method_33655().method_10260() + context.method_33654().method_43385(0.0, 4.0));
            int y = context.method_33652().method_8624(class_2902.class_2903.field_13195, x, z) - 1;
            this.placeOxygelium(context.method_33652(), x, y, z, context.method_33654());
        }
        this.placeElodea(worldAccess, mainPos.method_10263(), mainPos.method_10264(), mainPos.method_10260(), random);
        return true;
    }

    private void placeOxygelium(class_5281 world, int x, int y, int z, class_5819 random) {
        int max = random.method_39332(3, 10);
        for (int i = 0; i <= max; ++i) {
            class_2680 down = world.method_8320(new class_2338(x, y + i - 1, z));
            class_2680 state = world.method_8320(new class_2338(x, y + i, z));
            class_2680 up = world.method_8320(new class_2338(x, y + i + 1, z));
            if (!down.method_51367() && !this.isStem(down) || !state.method_51176()) continue;
            if (up.method_51176()) {
                world.method_8652(new class_2338(x, y + i, z), (class_2680)((class_2680)AquamiraeBlocks.OXYGELIUM.method_9564().method_11657(OxygeliumBlock.TYPE, (Comparable)((Object)(i < max ? OxygeliumBlock.Type.STEM : OxygeliumBlock.Type.EMPTY_BUD)))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE), 3);
                continue;
            }
            world.method_8652(new class_2338(x, y + i, z), (class_2680)((class_2680)AquamiraeBlocks.OXYGELIUM.method_9564().method_11657(OxygeliumBlock.TYPE, (Comparable)((Object)OxygeliumBlock.Type.EMPTY_BUD))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE), 3);
        }
    }

    private boolean isStem(class_2680 state) {
        return state.method_27852((class_2248)AquamiraeBlocks.OXYGELIUM) && state.method_11654(OxygeliumBlock.TYPE) == OxygeliumBlock.Type.STEM;
    }

    private void placeElodea(class_5281 world, int x, int y, int z, class_5819 random) {
        int max = random.method_39332(4, 24);
        block0: for (int i = 0; i <= max; ++i) {
            class_2338 pos = new class_2338(x + (int)Math.round(random.method_43385(0.0, 7.0)), y - 4, z + (int)Math.round(random.method_43385(0.0, 7.0)));
            for (int offset = 0; offset <= 10; ++offset) {
                if (world.method_8320(pos.method_10086(offset - 1)).method_26204() != class_2246.field_10255 && world.method_8320(pos.method_10086(offset - 1)).method_26204() != class_2246.field_10340 && world.method_8320(pos.method_10086(offset - 1)).method_26204() != class_2246.field_10445 || world.method_8320(pos.method_10086(offset)).method_26204() != class_2246.field_10382) continue;
                world.method_8652(pos.method_10086(offset), AquamiraeBlocks.ELODEA.method_9564(), 3);
                continue block0;
            }
        }
    }

    private void generateCutOut(class_5819 p_225100_, class_5281 p_225101_, int p_225102_, int p_225103_, class_2338 p_225104_, boolean p_225105_, int p_225106_, double p_225107_, int p_225108_) {
        int i = p_225100_.method_43056() ? -1 : 1;
        int j = p_225100_.method_43056() ? -1 : 1;
        int k = p_225100_.method_43048(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.method_43056()) {
            k = p_225102_ / 2 + 1 - p_225100_.method_43048(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        int l = p_225100_.method_43048(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.method_43056()) {
            l = p_225102_ / 2 + 1 - p_225100_.method_43048(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        if (p_225105_) {
            k = l = p_225100_.method_43048(Math.max(p_225106_ - 5, 1));
        }
        class_2338 blockpos = new class_2338(i * k, 0, j * l);
        double d0 = p_225105_ ? p_225107_ + 1.5707963267948966 : p_225100_.method_43058() * 2.0 * Math.PI;
        for (int i1 = 0; i1 < p_225103_ - 3; ++i1) {
            int j1 = this.heightDependentRadiusRound(p_225100_, i1, p_225103_, p_225102_);
            this.carve(j1, i1, p_225104_, p_225101_, false, d0, blockpos, p_225106_, p_225108_);
        }
        for (int k1 = -1; k1 > -p_225103_ + p_225100_.method_43048(5); --k1) {
            int l1 = this.heightDependentRadiusSteep(p_225100_, -k1, p_225103_, p_225102_);
            this.carve(l1, k1, p_225104_, p_225101_, true, d0, blockpos, p_225106_, p_225108_);
        }
    }

    private void carve(int p_66036_, int p_66037_, class_2338 p_66038_, class_5281 p_66039_, boolean p_66040_, double p_66041_, class_2338 p_66042_, int p_66043_, int p_66044_) {
        int i = p_66036_ + 1 + p_66043_ / 3;
        int j = Math.min(p_66036_ - 3, 3) + p_66044_ / 2 - 1;
        for (int k = -i; k < i; ++k) {
            for (int l = -i; l < i; ++l) {
                class_2338 blockpos;
                class_2680 blockstate;
                double d0 = this.signedDistanceEllipse(k, l, p_66042_, i, j, p_66041_);
                if (!(d0 < 0.0) || !OxygeliumFeature.isIcebergState(blockstate = p_66039_.method_8320(blockpos = p_66038_.method_10069(k, p_66037_, l))) || !p_66040_) continue;
                this.method_13153((class_1945)p_66039_, blockpos, class_2246.field_10382.method_9564());
            }
        }
    }

    private void generateIcebergBlock(class_5281 p_225110_, class_5819 p_225111_, class_2338 pos, int p_225113_, int p_225114_, int p_225115_, int p_225116_, int p_225117_, int p_225118_, boolean p_225119_, int p_225120_, double p_225121_, boolean p_225122_, class_2680 p_225123_) {
        double d0;
        double d = d0 = p_225119_ ? this.signedDistanceEllipse(p_225114_, p_225116_, class_2338.field_10980, p_225118_, this.getEllipseC(p_225115_, p_225113_, p_225120_), p_225121_) : this.signedDistanceCircle(p_225114_, p_225116_, p_225117_, p_225111_);
        if (d0 < 0.0) {
            double d1;
            class_2338 blockpos = pos.method_10069(p_225114_, p_225115_, p_225116_);
            double d2 = d1 = p_225119_ ? -0.5 : (double)(-6 - p_225111_.method_43048(3));
            if (d0 > d1 && p_225111_.method_43058() > 0.9) {
                return;
            }
            this.setIcebergBlock(blockpos, p_225110_, p_225111_, p_225113_ - p_225115_, p_225113_, p_225119_, p_225122_, p_225123_);
        }
    }

    private void setIcebergBlock(class_2338 pos, class_5281 levelAccessor, class_5819 p_225127_, int p_225128_, int p_225129_, boolean p_225130_, boolean p_225131_, class_2680 p_225132_) {
        if (levelAccessor.method_8320(pos.method_10084()).method_26215()) {
            return;
        }
        class_2680 blockstate = levelAccessor.method_8320(pos);
        if (blockstate.method_26215() || blockstate.method_27852(class_2246.field_10491) || blockstate.method_27852(class_2246.field_10295) || blockstate.method_27852(class_2246.field_10382)) {
            int i;
            boolean flag = !p_225130_ || p_225127_.method_43058() > 0.05;
            int n = i = p_225130_ ? 3 : 2;
            if (p_225131_ && (double)p_225128_ <= (double)p_225127_.method_43048(Math.max(1, p_225129_ / i)) + (double)p_225129_ * 0.6 && flag) {
                this.method_13153((class_1945)levelAccessor, pos, class_2246.field_10445.method_9564());
            } else {
                this.method_13153((class_1945)levelAccessor, pos, p_225132_);
            }
        }
    }

    private int getEllipseC(int p_66019_, int p_66020_, int p_66021_) {
        int i = p_66021_;
        if (p_66019_ > 0 && p_66020_ - p_66019_ <= 3) {
            i = p_66021_ - (4 - (p_66020_ - p_66019_));
        }
        return i;
    }

    private double signedDistanceCircle(int p_225089_, int p_225090_, int p_225092_, class_5819 p_225093_) {
        float f = 10.0f * class_3532.method_15363((float)p_225093_.method_43057(), (float)0.2f, (float)0.8f) / (float)p_225092_;
        return (double)f + Math.pow(p_225089_ - class_2338.field_11176.method_10263(), 2.0) + Math.pow(p_225090_ - class_2338.field_11176.method_10260(), 2.0) - Math.pow(p_225092_, 2.0);
    }

    private double signedDistanceEllipse(int p_66023_, int p_66024_, class_2338 p_66025_, int p_66026_, int p_66027_, double p_66028_) {
        return Math.pow(((double)(p_66023_ - p_66025_.method_10263()) * Math.cos(p_66028_) - (double)(p_66024_ - p_66025_.method_10260()) * Math.sin(p_66028_)) / (double)p_66026_, 2.0) + Math.pow(((double)(p_66023_ - p_66025_.method_10263()) * Math.sin(p_66028_) + (double)(p_66024_ - p_66025_.method_10260()) * Math.cos(p_66028_)) / (double)p_66027_, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(class_5819 p_225095_, int p_225096_, int p_225097_, int p_225098_) {
        float f = 3.5f - p_225095_.method_43057();
        float f1 = (1.0f - (float)Math.pow(p_225096_, 2.0) / ((float)p_225097_ * f)) * (float)p_225098_;
        if (p_225097_ > 15 + p_225095_.method_43048(5)) {
            int i = p_225096_ < 3 + p_225095_.method_43048(6) ? p_225096_ / 2 : p_225096_;
            f1 = (1.0f - (float)i / ((float)p_225097_ * f * 0.4f)) * (float)p_225098_;
        }
        return class_3532.method_15386((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusEllipse(int p_66110_, int p_66111_, int p_66112_) {
        float f1 = (1.0f - (float)Math.pow(p_66110_, 2.0) / (float)p_66111_) * (float)p_66112_;
        return class_3532.method_15386((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusSteep(class_5819 p_225134_, int p_225135_, int p_225136_, int p_225137_) {
        float f = 1.0f + p_225134_.method_43057() / 2.0f;
        float f1 = (1.0f - (float)p_225135_ / ((float)p_225136_ * f)) * (float)p_225137_;
        return class_3532.method_15386((float)(f1 / 2.0f));
    }

    private static boolean isIcebergState(class_2680 p_159886_) {
        return p_159886_.method_27852(class_2246.field_10340) || p_159886_.method_27852(class_2246.field_10445);
    }

    private boolean belowIsAir(class_5281 p_66046_, class_2338 p_66047_) {
        return p_66046_.method_8320(p_66047_.method_10074()).method_26204() == class_2246.field_10382;
    }

    private void smooth(class_5281 p_66052_, class_2338 p_66053_, int p_66054_, int p_66055_, boolean p_66056_, int p_66057_) {
        int i = p_66056_ ? p_66057_ : p_66054_ / 2;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                for (int l = 0; l <= p_66055_; ++l) {
                    class_2338 blockpos = p_66053_.method_10069(j, l, k);
                    class_2680 blockstate = p_66052_.method_8320(blockpos);
                    if (!OxygeliumFeature.isIcebergState(blockstate)) continue;
                    if (this.belowIsAir(p_66052_, blockpos)) {
                        this.method_13153((class_1945)p_66052_, blockpos, class_2246.field_10382.method_9564());
                        this.method_13153((class_1945)p_66052_, blockpos.method_10084(), class_2246.field_10382.method_9564());
                        continue;
                    }
                    if (!OxygeliumFeature.isIcebergState(blockstate)) continue;
                    class_2680[] ablockstate = new class_2680[]{p_66052_.method_8320(blockpos.method_10067()), p_66052_.method_8320(blockpos.method_10078()), p_66052_.method_8320(blockpos.method_10095()), p_66052_.method_8320(blockpos.method_10072())};
                    int i1 = 0;
                    for (class_2680 blockstate1 : ablockstate) {
                        if (OxygeliumFeature.isIcebergState(blockstate1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    this.method_13153((class_1945)p_66052_, blockpos, class_2246.field_10382.method_9564());
                }
            }
        }
    }
}

