/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.screen;

import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.screen.Button;
import wraith.fwaystones.screen.ToggleableButton;
import wraith.fwaystones.screen.UniversalWaystoneScreenHandler;
import wraith.fwaystones.screen.WaystoneBlockScreen;
import wraith.fwaystones.screen.WaystoneBlockScreenHandler;
import wraith.fwaystones.util.FWConfig;
import wraith.fwaystones.util.FWConfigModel;
import wraith.fwaystones.util.Utils;
import wraith.fwaystones.util.WaystonePacketHandler;

public class UniversalWaystoneScreen
extends class_465<class_1703> {
    protected final class_1661 inventory;
    protected final ArrayList<Button> buttons = new ArrayList();
    protected class_2960 texture;
    protected float scrollAmount;
    protected boolean mouseClicked;
    protected int scrollOffset;
    protected boolean ignoreTypedCharacter;
    protected boolean mousePressed;
    private class_342 searchField;

    public UniversalWaystoneScreen(final class_1703 handler, final class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.inventory = inventory;
        this.field_2792 = 177;
        this.field_2779 = 176;
        this.buttons.add(new Button(140, 25, 13, 13, 225, 0){

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                ((UniversalWaystoneScreenHandler)handler).toggleSearchType();
                UniversalWaystoneScreen.this.searchField.method_25365(((PlayerEntityMixinAccess)((UniversalWaystoneScreen)UniversalWaystoneScreen.this).field_22787.field_1724).fabricWaystones$autofocusWaystoneFields());
            }

            @Override
            public boolean isVisible() {
                return UniversalWaystoneScreen.this.searchVisible();
            }

            @Override
            public boolean hasToolTip() {
                return true;
            }

            @Override
            public class_2561 tooltip() {
                return ((UniversalWaystoneScreenHandler)handler).getSearchTypeTooltip();
            }
        });
        this.buttons.add(new ToggleableButton(24, 26, 8, 11, 177, 33, 185, 33){

            @Override
            public void setup() {
                this.toggled = ((PlayerEntityMixinAccess)inventory.field_7546).fabricWaystones$autofocusWaystoneFields();
                this.setupTooltip();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isVisible() {
                UniversalWaystoneScreen universalWaystoneScreen = UniversalWaystoneScreen.this;
                if (!(universalWaystoneScreen instanceof WaystoneBlockScreen)) return true;
                WaystoneBlockScreen waystoneBlockScreen = (WaystoneBlockScreen)universalWaystoneScreen;
                if (waystoneBlockScreen.page != WaystoneBlockScreen.Page.WAYSTONES) return false;
                return true;
            }

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                ((PlayerEntityMixinAccess)inventory.field_7546).fabricWaystones$toggleAutofocusWaystoneFields();
                this.setupTooltip();
            }

            private void setupTooltip() {
                this.tooltip = this.toggled ? class_2561.method_43471((String)"fwaystones.config.tooltip.unlock_search") : class_2561.method_43471((String)"fwaystones.config.tooltip.lock_search");
            }
        });
        this.setupButtons();
    }

    public void method_25419() {
        super.method_25419();
        class_2540 packet = PacketByteBufs.create();
        packet.method_10794(((PlayerEntityMixinAccess)this.inventory.field_7546).fabricWaystones$toTagW(new class_2487()));
        ClientPlayNetworking.send((class_2960)WaystonePacketHandler.SYNC_PLAYER_FROM_CLIENT, (class_2540)packet);
    }

    protected void setupButtons() {
        for (Button button : this.buttons) {
            button.setup();
        }
    }

    protected boolean searchVisible() {
        return true;
    }

    protected void method_25426() {
        super.method_25426();
        this.searchField = new class_342(this.field_22793, this.field_2776 + 37, this.field_2800 + 27, 93, 10, (class_2561)class_2561.method_43470((String)"")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                boolean bl;
                boolean bl2 = bl = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
                if (bl && button == 1) {
                    this.method_1852("");
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchField.method_1880(16);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1862(true);
        this.searchField.method_1858(false);
        this.searchField.method_1856(true);
        this.searchField.method_1852("");
        this.searchField.method_1863(s -> {
            this.scrollAmount = 0.0f;
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5);
            ((UniversalWaystoneScreenHandler)this.field_2797).setFilter(this.searchField != null ? this.searchField.method_1882() : "");
            ((UniversalWaystoneScreenHandler)this.field_2797).filterWaystones();
        });
        this.method_25429((class_364)this.searchField);
    }

    public void method_37432() {
        if (this.searchField != null && this.searchField.method_1885() && ((PlayerEntityMixinAccess)this.field_22787.field_1724).fabricWaystones$autofocusWaystoneFields()) {
            this.searchField.method_25365(true);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        String string = this.searchField.method_1882();
        this.method_25423(client, width, height);
        this.searchField.method_1852(string);
        super.method_25410(client, width, height);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        context.method_25302(this.texture, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        int k = (int)(75.0f * this.scrollAmount);
        context.method_25302(this.texture, this.field_2776 + 141, this.field_2800 + 40 + k, 177 + (this.shouldScroll() ? 0 : 11), 0, 11, 15);
        int n = this.scrollOffset + 5;
        this.renderWaystoneBackground(context, mouseX, mouseY, this.field_2776 + 36, this.field_2800 + 39, n);
        this.renderForgetButtons(context, mouseX, mouseY, this.field_2776 + 24, this.field_2800 + 45);
        this.renderButtons(context, mouseX, mouseY);
        this.renderCostItem(context, this.field_2776 + 23, this.field_2800 + 136);
        this.renderWaystoneNames(context, this.field_2776 + 36, this.field_2800 + 40, n);
        this.renderWaystoneTooltips(context, mouseX, mouseY, this.field_2776 + 36, this.field_2800 + 39, n);
        this.renderWaystoneAmount(context, this.field_2776 + 10, this.field_2800 + 160);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        this.renderForgetTooltips(context, mouseX, mouseY, this.field_2776 + 24, this.field_2800 + 45);
        this.renderButtonTooltips(context, mouseX, mouseY);
    }

    protected void renderButtonTooltips(class_332 context, int mouseX, int mouseY) {
        for (Button button : this.buttons) {
            if (!button.isVisible() || !button.hasToolTip() || !button.isInBounds(mouseX - this.field_2776, mouseY - this.field_2800)) continue;
            context.method_51438(this.field_22793, button.tooltip(), mouseX, mouseY);
        }
    }

    private void renderWaystoneAmount(class_332 context, int x, int y) {
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"fwaystones.gui.displayed_waystones", (Object[])new Object[]{this.getDiscoveredCount()}), x, y, 0x161616, false);
    }

    protected void renderButtons(class_332 context, int mouseX, int mouseY) {
        for (Button button : this.buttons) {
            if (!button.isVisible()) continue;
            int u = button.getU();
            int v = button.getV();
            if (button.isInBounds(mouseX - this.field_2776, mouseY - this.field_2800)) {
                v += button.getHeight() * (this.mousePressed ? 1 : 2);
            }
            context.method_25302(this.texture, this.field_2776 + button.getX(), this.field_2800 + button.getY(), u, v, button.getWidth(), button.getHeight());
        }
    }

    public boolean method_25400(char chr, int keyCode) {
        if (this.ignoreTypedCharacter) {
            return false;
        }
        return this.searchField.method_25400(chr, keyCode);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.ignoreTypedCharacter = false;
        if (class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent() && this.method_2384(keyCode, scanCode)) {
            this.ignoreTypedCharacter = true;
            return true;
        }
        if (this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.searchField.method_25370() && this.searchField.method_1885() && keyCode != 256 || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void renderCostItem(class_332 context, int x, int y) {
        FWConfig.Teleportation_cost config = FabricWaystones.CONFIG.teleportation_cost;
        this.renderCostText(context, x, y, switch (config.cost_type()) {
            case FWConfigModel.CostType.HEALTH -> {
                context.method_25302(this.texture, x, y + 4, 186, 15, 9, 9);
                yield class_2561.method_43471((String)"fwaystones.cost.health");
            }
            case FWConfigModel.CostType.HUNGER -> {
                context.method_25302(this.texture, x, y + 4, 177, 24, 9, 9);
                yield class_2561.method_43471((String)"fwaystones.cost.hunger");
            }
            case FWConfigModel.CostType.EXPERIENCE -> {
                context.method_25302(this.texture, x, y + 4, 177, 15, 9, 9);
                yield class_2561.method_43471((String)"fwaystones.cost.xp");
            }
            case FWConfigModel.CostType.LEVEL -> {
                context.method_51431(this.field_22793, new class_1799((class_1935)class_1802.field_8287), x, y);
                yield class_2561.method_43471((String)"fwaystones.cost.level");
            }
            case FWConfigModel.CostType.ITEM -> {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(Utils.getTeleportCostItem());
                context.method_51431(this.field_22793, new class_1799((class_1935)item), x, y);
                yield (class_5250)item.method_7848();
            }
            default -> {
                context.method_25302(this.texture, x, y + 4, 186, 24, 9, 9);
                yield class_2561.method_43471((String)"fwaystones.cost.free");
            }
        });
    }

    protected void renderCostText(class_332 context, int x, int y, class_5250 text) {
        this.renderCostText(context, x, y, text, 0x161616);
    }

    protected void renderCostText(class_332 context, int x, int y, class_5250 text, int color) {
        if (!FabricWaystones.CONFIG.teleportation_cost.cost_type().equals((Object)FWConfigModel.CostType.NONE)) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)(": " + FabricWaystones.CONFIG.teleportation_cost.base_cost())));
        }
        context.method_51439(this.field_22793, (class_2561)text, x + 16, y + 5, color, false);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    protected void renderForgetButtons(class_332 context, int mouseX, int mouseY, int x, int y) {
        int n = this.getDiscoveredCount();
        for (int i = 0; i < 5; ++i) {
            int r = y + i * 18;
            int v = 0;
            if (i >= n) {
                v = 8;
            } else if (mouseX >= x && mouseY >= r && mouseX < x + 8 && mouseY < r + 8) {
                v += 8 * (this.mouseClicked ? 1 : 2);
            }
            context.method_25302(this.texture, x, r, 199, v, 8, 8);
        }
    }

    protected void renderForgetTooltips(class_332 context, int mouseX, int mouseY, int x, int y) {
        int n = this.getDiscoveredCount();
        for (int i = 0; i < n; ++i) {
            int r = y + i * 18;
            if (mouseX < x || mouseY < r || mouseX > x + 8 || mouseY >= r + 8) continue;
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"fwaystones.gui.forget_tooltip"), mouseX, mouseY);
        }
    }

    protected void renderWaystoneBackground(class_332 context, int mouseX, int mouseY, int x, int y, int m) {
        for (int n = this.scrollOffset; n < m && n < this.getDiscoveredCount(); ++n) {
            int o = n - this.scrollOffset;
            int r = y + o * 18 + 2;
            int s = this.field_2779;
            if (mouseX >= x && mouseY >= r && mouseX < x + 101 && mouseY < r + 18) {
                s += this.mouseClicked ? 18 : 36;
            }
            context.method_25302(this.texture, x, r - 1, 0, s, 101, 18);
        }
    }

    protected void renderWaystoneTooltips(class_332 context, int mouseX, int mouseY, int x, int y, int m) {
        ArrayList<String> waystones = this.getDiscoveredWaystones();
        for (int n = this.scrollOffset; n < m && n < this.getDiscoveredCount(); ++n) {
            WaystoneValue waystoneData;
            int o = n - this.scrollOffset;
            int r = y + o * 18 + 2;
            if (mouseX < x || mouseY < r || mouseX >= x + 101 || mouseY >= r + 18 || (waystoneData = FabricWaystones.WAYSTONE_STORAGE.getWaystoneData(waystones.get(n))) == null) continue;
            String startDim = Utils.getDimensionName(this.field_22787.field_1724.method_37908());
            String endDim = waystoneData.getWorldName();
            ArrayList<class_5250> tooltipContents = new ArrayList<class_5250>();
            int cost = Utils.getCost(class_243.method_24953((class_2382)waystoneData.way_getPos()), this.field_22787.field_1724.method_19538(), startDim, endDim);
            tooltipContents.add(class_2561.method_43469((String)"fwaystones.gui.cost_tooltip", (Object[])new Object[]{cost == 0 ? class_2561.method_43471((String)"fwaystones.cost.free").getString() : Integer.valueOf(cost)}));
            if (UniversalWaystoneScreen.method_25442()) {
                tooltipContents.add(class_2561.method_43469((String)"fwaystones.gui.dimension_tooltip", (Object[])new Object[]{waystoneData.getWorldName()}));
            }
            context.method_51434(this.field_22793, tooltipContents, mouseX, mouseY);
        }
    }

    protected void renderWaystoneNames(class_332 context, int x, int y, int m) {
        if (FabricWaystones.WAYSTONE_STORAGE == null) {
            return;
        }
        ArrayList<String> waystones = this.getDiscoveredWaystones();
        for (int n = this.scrollOffset; n < m && n < waystones.size(); ++n) {
            int o = n - this.scrollOffset;
            int r = y + o * 18 + 2;
            String name = FabricWaystones.WAYSTONE_STORAGE.getName(waystones.get(n));
            context.method_51433(this.field_22793, name, x + 5, r - 1 + 5, 0x161616, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mousePressed = true;
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        this.mouseClicked = false;
        if (this.hasWaystones() && this.canClickWaystones() && this.tryClick(mouseX, mouseY)) {
            return true;
        }
        for (Button guiButton : this.buttons) {
            if (!guiButton.isVisible() || !guiButton.isInBounds((int)mouseX - this.field_2776, (int)mouseY - this.field_2800)) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            guiButton.onClick();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean canClickWaystones() {
        return true;
    }

    protected boolean tryClick(double mouseX, double mouseY) {
        int forgetButtonX = this.field_2776 + 24;
        int forgetButtonY = this.field_2800 + 45;
        int waystoneButtonX = this.field_2776 + 36;
        int waystoneButtonY = this.field_2800 + 40;
        int adjustedScrollOffset = this.scrollOffset + 5;
        int n = this.getDiscoveredCount();
        for (int currentWaystone = this.scrollOffset; currentWaystone < adjustedScrollOffset && currentWaystone < n; ++currentWaystone) {
            WaystoneBlockScreenHandler waystoneBlockScreenHandler;
            class_1703 packet;
            class_2487 tag;
            int currentWaystoneOffsetPosition = currentWaystone - this.scrollOffset;
            int forgetButtonStartX = (int)(mouseX - (double)forgetButtonX);
            int forgetButtonStartY = (int)(mouseY - (double)(forgetButtonY + currentWaystoneOffsetPosition * 18));
            int waystoneButtonStartX = (int)(mouseX - (double)waystoneButtonX);
            int waystoneButtonStartY = (int)(mouseY - (double)(waystoneButtonY + currentWaystoneOffsetPosition * 18));
            if (currentWaystoneOffsetPosition < n && (double)forgetButtonStartX >= 0.0 && (double)forgetButtonStartY >= 0.0 && forgetButtonStartX < 8 && forgetButtonStartY < 8 && this.field_2797.method_7604((class_1657)this.field_22787.field_1724, currentWaystone * 2 + 1)) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14542, (float)1.0f));
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
                tag = new class_2487();
                tag.method_10569("sync_id", this.field_2797.field_7763);
                tag.method_10569("clicked_slot", currentWaystone * 2 + 1);
                packet = PacketByteBufs.create().method_10794(tag);
                ClientPlayNetworking.send((class_2960)WaystonePacketHandler.WAYSTONE_GUI_SLOT_CLICK, (class_2540)packet);
                return true;
            }
            packet = this.field_2797;
            if (packet instanceof WaystoneBlockScreenHandler && (waystoneBlockScreenHandler = (WaystoneBlockScreenHandler)packet).getWaystone().equals(this.getDiscoveredWaystones().get(currentWaystone)) || !((double)waystoneButtonStartX >= 0.0) || !((double)waystoneButtonStartY >= 0.0) || !((double)waystoneButtonStartX < 101.0) || !((double)waystoneButtonStartY < 18.0) || !this.field_2797.method_7604((class_1657)this.field_22787.field_1724, currentWaystone * 2)) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            tag = new class_2487();
            tag.method_10569("sync_id", this.field_2797.field_7763);
            tag.method_10569("clicked_slot", currentWaystone * 2);
            packet = PacketByteBufs.create().method_10794(tag);
            ClientPlayNetworking.send((class_2960)WaystonePacketHandler.WAYSTONE_GUI_SLOT_CLICK, (class_2540)packet);
            return true;
        }
        int i3 = this.field_2776 + 141;
        int j3 = this.field_2800 + 40;
        if (mouseX >= (double)i3 && mouseX < (double)(i3 + 11) && mouseY >= (double)j3 && mouseY < (double)(j3 + 90)) {
            this.mouseClicked = true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - amount / (double)i);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 40;
            int j = i + 90;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected boolean hasWaystones() {
        return this.getDiscoveredCount() > 0;
    }

    protected boolean shouldScroll() {
        return this.getDiscoveredCount() > 5;
    }

    protected int getMaxScroll() {
        return this.getDiscoveredCount() - 5;
    }

    protected int getDiscoveredCount() {
        return ((UniversalWaystoneScreenHandler)this.field_2797).getWaystonesCount();
    }

    protected ArrayList<String> getDiscoveredWaystones() {
        return ((UniversalWaystoneScreenHandler)this.field_2797).getSearchedWaystones();
    }

    protected boolean superMouseScrolled(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount);
    }

    protected boolean superMouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void superResize(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
    }

    protected void superOnMouseClick(class_1735 slot, int invSlot, int clickData, class_1713 actionType) {
        super.method_2383(slot, invSlot, clickData, actionType);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        this.mousePressed = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    protected boolean superMouseClicked(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }
}

