/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.patched.client.CMinecraft;
import tocraft.craftedcore.platform.PlatformData;

public class VIPs {
    public static final String patreonURL = "https://raw.githubusercontent.com/ToCraft/craftedcore/main/common/src/main/resources/patreons.txt";
    private static final List<UUID> CACHED_PATREONS = new ArrayList<UUID>();
    private static final Path CACHE_FILE = CraftedCore.CACHE_DIR.resolve("patreons.txt");

    public static List<UUID> getCachedPatreons() {
        return CACHED_PATREONS;
    }

    public static List<UUID> cachePatreons() {
        if (CACHED_PATREONS.isEmpty()) {
            CACHED_PATREONS.addAll(VIPs.getPatreons());
        }
        StringBuilder s = new StringBuilder();
        for (UUID cachedPatreon : CACHED_PATREONS) {
            s.append(cachedPatreon).append("\n");
        }
        try {
            CACHE_FILE.getParent().toFile().mkdirs();
            Files.writeString(CACHE_FILE, (CharSequence)s, new OpenOption[0]);
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
        }
        return CACHED_PATREONS;
    }

    public static List<UUID> getPatreons() {
        ArrayList<UUID> patreons = new ArrayList<UUID>();
        try {
            URL localPatreons;
            for (UUID uuidOfPerson : VIPs.getUUIDOfPeople(new URI(patreonURL).toURL())) {
                if (patreons.contains(uuidOfPerson)) continue;
                patreons.add(uuidOfPerson);
            }
            if (CACHE_FILE.toFile().exists() && patreons.isEmpty()) {
                URL cachedPatreons = CACHE_FILE.toFile().toURI().toURL();
                for (UUID uuidOfPerson : VIPs.getUUIDOfPeople(cachedPatreons)) {
                    if (patreons.contains(uuidOfPerson)) continue;
                    patreons.add(uuidOfPerson);
                }
            }
            if ((localPatreons = CraftedCore.class.getResource("/patreons.txt")) != null) {
                for (UUID uuidOfPerson : VIPs.getUUIDOfPeople(localPatreons)) {
                    if (patreons.contains(uuidOfPerson)) continue;
                    patreons.add(uuidOfPerson);
                }
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            CraftedCore.LOGGER.error("Invalid patreon url: https://raw.githubusercontent.com/ToCraft/craftedcore/main/common/src/main/resources/patreons.txt", (Throwable)e);
        }
        return patreons;
    }

    public static List<UUID> getUUIDOfPeople(URL url) {
        ArrayList<UUID> people = new ArrayList<UUID>();
        try {
            String line;
            BufferedReader updateReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((line = updateReader.readLine()) != null && !(line = line.replaceAll("\n", "").replaceAll("\r", "")).isBlank()) {
                people.add(UUID.fromString(line));
            }
            updateReader.close();
        }
        catch (IOException e) {
            if (e instanceof SocketException || e instanceof UnknownHostException) {
                CraftedCore.reportMissingInternet(e);
            }
            CraftedCore.LOGGER.error("Couldn't get patreons from https://raw.githubusercontent.com/ToCraft/craftedcore/main/common/src/main/resources/patreons.txt", (Throwable)e);
        }
        if (PlatformData.getEnv() == EnvType.CLIENT && people.contains(CMinecraft.getLocalPlayerUUID())) {
            CraftedCore.LOGGER.info("Thank you for supporting me and my mods! ~To_Craft");
        }
        return people;
    }

    public static void clearCache() {
        CraftedCore.forceDeleteFile(CACHE_FILE.toFile());
        CACHED_PATREONS.clear();
    }
}

