/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.registration.PlayerDataRegistry;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final class_2960 PLAYER_DATA_SYNC_ID = CraftedCore.id("player_data_sync");

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            class_2499 list;
            if (tag != null && (list = (class_2499)tag.method_10580(PLAYER_DATA_SYNC)) != null) {
                for (class_2520 entry : list) {
                    for (String key : ((class_2487)entry).method_10541()) {
                        if (Objects.equals(key, "DELETED")) {
                            ClientNetworking.runOrQueue(context, player -> {
                                PlayerDataProvider playerDataProvider = tag.method_25928("uuid") ? (PlayerDataProvider)player.method_5770().method_18470(tag.method_25926("uuid")) : (PlayerDataProvider)player;
                                if (playerDataProvider != null) {
                                    playerDataProvider.craftedcore$writeTag(Objects.requireNonNull(((class_2487)entry).method_10580(key)).method_10714(), null);
                                }
                            });
                            continue;
                        }
                        ClientNetworking.runOrQueue(context, player -> {
                            PlayerDataProvider playerDataProvider = tag.method_25928("uuid") ? (PlayerDataProvider)player.method_5770().method_18470(tag.method_25926("uuid")) : (PlayerDataProvider)player;
                            if (playerDataProvider != null) {
                                playerDataProvider.craftedcore$writeTag(key, ((class_2487)entry).method_10580(key));
                            }
                        });
                    }
                }
            }
        });
    }

    public static void sync(class_3222 player) {
        PlayerDataSynchronizer.syncToSelf(player);
        PlayerDataSynchronizer.syncToAll(player);
    }

    private static void syncToSelf(class_3222 player) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncTagToSelf(key)) {
                return;
            }
            class_2487 entry = new class_2487();
            class_2520 value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.method_10566(key, value);
            } else {
                entry.method_10566("DELETED", (class_2520)class_2519.method_23256((String)key));
            }
            list.add((Object)entry);
        }
        tag.method_10566(PLAYER_DATA_SYNC, (class_2520)list);
        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }

    private static void syncToAll(class_3222 player) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        tag.method_25927("uuid", player.method_5667());
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncTagToAll(key)) {
                return;
            }
            class_2487 entry = new class_2487();
            class_2520 value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.method_10566(key, value);
            } else {
                entry.method_10566("DELETED", (class_2520)class_2519.method_23256((String)key));
            }
            list.add((Object)entry);
        }
        tag.method_10566(PLAYER_DATA_SYNC, (class_2520)list);
        ModernNetworking.sendToPlayers(((class_3218)CEntity.level((class_1297)player)).method_18456(), PLAYER_DATA_SYNC_ID, tag);
    }
}

