/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NetUtils {
    public static byte @NotNull [] getByteResponse(URL url) throws IOException {
        return NetUtils.getByteResponse(new HashMap<String, String>(), url);
    }

    public static byte @NotNull [] getByteResponse(Map<String, String> header, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        for (Map.Entry<String, String> entry : header.entrySet()) {
            connection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        byte[] response = connection.getInputStream().readAllBytes();
        connection.disconnect();
        return response;
    }

    @NotNull
    public static String getTextResponse(Map<String, String> header, URL url) throws IOException {
        byte[] response = NetUtils.getByteResponse(header, url);
        return new String(response, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String getTextResponse(URL url) throws IOException {
        return NetUtils.getTextResponse(new HashMap<String, String>(), url);
    }

    public static JsonElement getJsonResponse(Gson gson, URL url) throws IOException {
        return NetUtils.getJsonResponse(gson, new HashMap<String, String>(), url);
    }

    public static JsonElement getJsonResponse(Gson gson, Map<String, String> header, URL url) throws IOException {
        String response = NetUtils.getTextResponse(header, url);
        return (JsonElement)gson.fromJson(response, JsonElement.class);
    }
}

