/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.google.gson.GsonBuilder;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.config.input.KeyBind;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.integration.IRecipeAction;
import mcp.mobius.waila.registry.PluginAware;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.registry.RegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_1799;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public abstract class WailaClient {
    private static final Log LOG = Log.create();
    public static final IJsonConfig<WailaConfig> CONFIG = IJsonConfig.of(WailaConfig.class).file("waila/waila").version(1, WailaConfig::getConfigVersion, WailaConfig::setConfigVersion).json5().commenter(WailaConfig.COMMENTER).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WailaConfig.Overlay.Color.class, (Object)new WailaConfig.Overlay.Color.Adapter()).registerTypeAdapter(ThemeDefinition.class, (Object)new ThemeDefinition.Adapter()).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(KeyBind.class, (Object)new KeyBind.Adapter()).create()).build();
    public static boolean showComponentBounds = false;
    public static boolean showFps = false;
    @Nullable
    private static IRecipeAction recipeAction;

    public static void setRecipeAction(IRecipeAction action) {
        if (recipeAction == null) {
            LOG.info("Show recipe action set for " + action.getModName());
        } else if (!recipeAction.getModName().equals(action.getModName())) {
            LOG.warn("Show recipe action is already set for " + recipeAction.getModName());
            LOG.warn("Replaced it with one for " + action.getModName());
        }
        recipeAction = action;
    }

    protected static void onClientTick() {
        Waila.onAnyTick();
        class_310 client = class_310.method_1551();
        WailaConfig config = CONFIG.get();
        WailaConfig.General general = config.getGeneral();
        WailaConfig.KeyBinds binds = config.getKeyBinds();
        KeyBind.tick();
        TooltipHandler.tick();
        if (client.field_1755 == null) {
            if (binds.getOpenConfig().isPressed()) {
                client.method_1507((class_437)new WailaConfigScreen(null));
            }
            if (binds.getShowOverlay().isPressed() && general.getDisplayMode() == IWailaConfig.General.DisplayMode.TOGGLE) {
                general.setDisplayTooltip(!general.isDisplayTooltip());
            }
            if (binds.getToggleLiquid().isPressed()) {
                PluginConfig.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
            }
            if (recipeAction != null) {
                if (binds.getShowRecipeInput().isPressed()) {
                    recipeAction.showInput(ClientAccessor.INSTANCE.getStack());
                }
                if (binds.getShowRecipeOutput().isPressed()) {
                    recipeAction.showOutput(ClientAccessor.INSTANCE.getStack());
                }
            }
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ITEM_MOD_NAME)) {
            for (IInstanceRegistry.Entry<PluginAware<IEventListener>> listener : Registrar.get().eventListeners.get(Object.class)) {
                String name = listener.instance().instance().getHoveredItemModName(stack, PluginConfig.CLIENT);
                if (name == null) continue;
                tooltip.add(IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(class_2535 connection) {
        ClientAccessor.INSTANCE.hasServer = false;
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    protected static void onServerLogout(class_2535 connection) {
        ClientAccessor.INSTANCE.hasServer = false;
        RegistryFilter.attach(null);
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }
}

