/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<class_1832, ToolTier>> TIERS = Suppliers.memoize(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<class_1832> tiers = IApiService.INSTANCE.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            class_1832 tier = tiers.get(i);
            builder.put((Object)tier, (Object)new ToolTier(tier, i));
        }
        return builder.build();
    });
    private static final Supplier<Map<class_2960, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> {
        HashMap<class_2960, String> map = new HashMap<class_2960, String>();
        for (class_1834 tier : class_1834.values()) {
            class_6862<class_2248> tag = IApiService.INSTANCE.getTierTag((class_1832)tier);
            if (tag == null) continue;
            map.put(tag.comp_327(), tier.name().toLowerCase(Locale.ROOT));
        }
        return map;
    });
    public final class_1832 tier;
    public final int index;
    @Nullable
    public final class_6862<class_2248> tag;
    private final Supplier<String> tlKey;

    public ToolTier(class_1832 tier, int index) {
        this.tier = tier;
        this.index = index;
        this.tag = IApiService.INSTANCE.getTierTag(tier);
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla;
            String key = this.tag != null ? ((vanilla = VANILLA_TIER_TL_KEYS.get().get(this.tag.comp_327())) != null ? vanilla : this.tag.comp_327().method_42094()) : String.valueOf(tier.method_8024());
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static Collection<ToolTier> all() {
        return TIERS.get().values();
    }

    @Nullable
    public static ToolTier get(class_1832 tier) {
        return TIERS.get().get(tier);
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        if (this.tag != null && other.tag != null) {
            return this.tag.comp_327().equals((Object)other.tag.comp_327());
        }
        return false;
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }
}

