/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2724;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ScaleUtils;
import virtuoel.pehkui.util.VersionUtils;

public class ScaleRenderUtils {
    public static final MethodHandles.Lookup LOOKUP;
    public static final MethodHandle DRAW_BOX_OUTLINE;
    public static final MethodHandle SHOULD_KEEP_PLAYER_ATTRIBUTES;
    public static final MethodHandle HAS_EXTENDED_REACH;
    public static final MethodHandle GET_TICK_DELTA;
    public static final MethodType RECEIVE_TYPE;
    public static final MethodType FACTORY_METHOD_TYPE;
    public static final Method REGISTER_GLOBAL_RECEIVER;
    public static final Class<?> PACKET_SENDER;
    private static final Set<class_1792> loggedItems;
    private static class_1799 lastRenderedStack;
    private static int itemRecursionDepth;
    private static int maxItemRecursionDepth;
    private static final Set<class_1299<?>> loggedEntityTypes;
    private static class_1299<?> lastRenderedEntity;
    private static int entityRecursionDepth;
    private static int maxEntityRecursionDepth;

    public static void registerPacketHandler(class_2960 id, Class<?> clazz, String methodName) {
        if (REGISTER_GLOBAL_RECEIVER != null && RECEIVE_TYPE != null && FACTORY_METHOD_TYPE != null && PACKET_SENDER != null) {
            try {
                Method staticRegister = clazz.getDeclaredMethod(methodName, class_310.class, class_634.class, class_2540.class, Object.class);
                MethodHandle staticRegisterHandle = LOOKUP.unreflect(staticRegister);
                MethodType staticRegisterType = staticRegisterHandle.type().changeParameterType(3, PACKET_SENDER);
                CallSite lambdaFactory = LambdaMetafactory.metafactory(LOOKUP, "receive", FACTORY_METHOD_TYPE, RECEIVE_TYPE, staticRegisterHandle, staticRegisterType);
                MethodHandle factoryInvoker = lambdaFactory.getTarget();
                Object handlerLambda = factoryInvoker.asType(FACTORY_METHOD_TYPE).invokeWithArguments(Collections.emptyList());
                REGISTER_GLOBAL_RECEIVER.invoke(null, id, handlerLambda);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static float getTickDelta(class_310 client) {
        if (GET_TICK_DELTA != null) {
            try {
                return GET_TICK_DELTA.invoke(client);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return client.method_60646().method_60637(false);
    }

    public static boolean hasExtendedReach(class_636 interactionManager) {
        if (HAS_EXTENDED_REACH != null) {
            try {
                return HAS_EXTENDED_REACH.invoke(interactionManager);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return interactionManager.method_2920().method_8386();
    }

    public static boolean wasPlayerAlive(class_2724 packet) {
        if ((VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2) && SHOULD_KEEP_PLAYER_ATTRIBUTES != null) {
            try {
                return SHOULD_KEEP_PLAYER_ATTRIBUTES.invoke(packet);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return packet.method_48016((byte)1);
    }

    public static void renderInteractionBox(@Nullable Object matrices, @Nullable Object vertices, class_238 box) {
        ScaleRenderUtils.renderInteractionBox(matrices, vertices, box, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    public static void renderInteractionBox(@Nullable Object matrices, @Nullable Object vertices, class_238 box, float red, float green, float blue, float alpha) {
        if (VersionUtils.MINOR >= 15) {
            class_761.method_22982((class_4587)((class_4587)matrices), (class_4588)((class_4588)vertices), (class_238)box, (float)red, (float)green, (float)blue, (float)alpha);
        } else if (DRAW_BOX_OUTLINE != null) {
            try {
                DRAW_BOX_OUTLINE.invoke(box, red, green, blue, alpha);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final float modifyProjectionMatrixDepthByWidth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepthByHeight(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getEyeHeightScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(Math.min(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), ScaleUtils.getEyeHeightScale(entity, tickDelta)), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float scale, float depth, class_1297 entity, float tickDelta) {
        if (scale < 1.0f) {
            return Math.max(depth * scale, (float)PehkuiConfig.CLIENT.minimumCameraDepth.get().doubleValue());
        }
        return depth;
    }

    public static boolean shouldSkipHeadItemScaling(@Nullable class_1309 entity, class_1799 item, Object renderMode) {
        return "HEAD".equals(((Enum)renderMode).name()) && (entity == null || entity.method_6118(class_1304.field_6173) != item && entity.method_6118(class_1304.field_6171) != item);
    }

    public static void logIfRenderCancelled() {
        ScaleRenderUtils.logIfItemRenderCancelled(true);
        ScaleRenderUtils.logIfEntityRenderCancelled(true);
    }

    public static void logIfItemRenderCancelled() {
        ScaleRenderUtils.logIfItemRenderCancelled(false);
    }

    private static void logIfItemRenderCancelled(boolean force) {
        if (lastRenderedStack != null && (force || itemRecursionDepth >= maxItemRecursionDepth)) {
            class_1792 i = lastRenderedStack.method_7909();
            if (force || !loggedItems.contains(i)) {
                String itemKey;
                String stackKey = lastRenderedStack.method_7922();
                if (stackKey.equals(itemKey = lastRenderedStack.method_7909().method_7876())) {
                    Pehkui.LOGGER.error("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}).", new Object[]{"pehkui", stackKey, lastRenderedStack.method_7909()});
                } else {
                    Pehkui.LOGGER.error("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}) ({})", new Object[]{"pehkui", stackKey, itemKey, lastRenderedStack.method_7909()});
                }
                loggedItems.add(i);
            }
        }
    }

    public static void saveLastRenderedItem(class_1799 currentStack) {
        if (itemRecursionDepth == 0) {
            lastRenderedStack = currentStack;
        }
        ++itemRecursionDepth;
    }

    public static void clearLastRenderedItem() {
        lastRenderedStack = null;
        itemRecursionDepth = 0;
    }

    public static void logIfEntityRenderCancelled() {
        ScaleRenderUtils.logIfEntityRenderCancelled(false);
    }

    private static void logIfEntityRenderCancelled(boolean force) {
        if (!(lastRenderedEntity == null || !force && entityRecursionDepth < maxEntityRecursionDepth || !force && loggedEntityTypes.contains(lastRenderedEntity))) {
            class_2960 id = class_1299.method_5890(lastRenderedEntity);
            Pehkui.LOGGER.error("[{}]: Did something cancel entity rendering early? Matrix stack was not popped after rendering entity {}.", new Object[]{"pehkui", id});
            loggedEntityTypes.add(lastRenderedEntity);
        }
    }

    public static void saveLastRenderedEntity(class_1299<?> type) {
        if (entityRecursionDepth == 0) {
            lastRenderedEntity = type;
        }
        ++entityRecursionDepth;
    }

    public static void clearLastRenderedEntity() {
        lastRenderedEntity = null;
        entityRecursionDepth = 0;
    }

    public static void addDetailsToCrashReport(class_129 section) {
        if (lastRenderedStack != null) {
            section.method_578("pehkui:debug/render/item", (Object)lastRenderedStack.method_7909().method_7876());
        }
        if (lastRenderedEntity != null) {
            class_2960 id = class_1299.method_5890(lastRenderedEntity);
            section.method_578("pehkui:debug/render/entity", (Object)id);
        }
    }

    static {
        EnvType env = FabricLoader.getInstance().getEnvironmentType();
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap handles = new Int2ObjectArrayMap();
        Int2ObjectArrayMap types = new Int2ObjectArrayMap();
        Int2ObjectArrayMap methods = new Int2ObjectArrayMap();
        Class[] classes = new Class[1];
        MethodHandles.Lookup lookup = LOOKUP = MethodHandles.lookup();
        String mapped = "unset";
        try {
            Method m;
            boolean is1206Minus;
            boolean is114Minus = VersionUtils.MINOR <= 14;
            boolean is116Plus = VersionUtils.MINOR >= 16;
            boolean is1192Minus = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2;
            boolean is1204Minus = VersionUtils.MINOR < 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH <= 4;
            boolean bl = is1206Minus = VersionUtils.MINOR < 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH <= 6;
            if (is114Minus && env == EnvType.CLIENT) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_761", "method_3260", "(Lnet/minecraft/class_238;FFFF)V");
                m = class_761.class.getMethod(mapped, class_238.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
                handles.put(0, (Object)lookup.unreflect(m));
            }
            if (is116Plus && is1192Minus) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2724", "method_27904", "()Z");
                m = class_2724.class.getMethod(mapped, new Class[0]);
                handles.put(1, (Object)lookup.unreflect(m));
            }
            if (is1204Minus && env == EnvType.CLIENT) {
                if (ModLoaderUtils.isModLoaded("fabric-networking-api-v1")) {
                    mapped = "net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking";
                    Class<?> networkingClass = Class.forName(mapped);
                    mapped = "net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking$PlayChannelHandler";
                    Class<?> handlerClass = Class.forName(mapped);
                    mapped = "net.fabricmc.fabric.api.networking.v1.PacketSender";
                    classes[0] = Class.forName(mapped);
                    m = networkingClass.getMethod("registerGlobalReceiver", class_2960.class, handlerClass);
                    methods.put(2, (Object)m);
                    m = handlerClass.getDeclaredMethod("receive", class_310.class, class_634.class, class_2540.class, classes[0]);
                    MethodType t = MethodType.methodType(m.getReturnType(), m.getParameterTypes());
                    types.put(3, (Object)t);
                    t = MethodType.methodType(handlerClass);
                    types.put(4, (Object)t);
                }
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_636", "method_2926", "()Z");
                m = class_636.class.getMethod(mapped, new Class[0]);
                handles.put(5, (Object)lookup.unreflect(m));
            }
            if (is1206Minus && env == EnvType.CLIENT) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_310", "method_1488", "()F");
                m = class_310.class.getMethod(mapped, new Class[0]);
                handles.put(6, (Object)lookup.unreflect(m));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException e) {
            Pehkui.LOGGER.error("Current name lookup: {}", new Object[]{mapped});
            Pehkui.LOGGER.catching((Throwable)e);
        }
        DRAW_BOX_OUTLINE = (MethodHandle)handles.get(0);
        SHOULD_KEEP_PLAYER_ATTRIBUTES = (MethodHandle)handles.get(1);
        REGISTER_GLOBAL_RECEIVER = (Method)methods.get(2);
        RECEIVE_TYPE = (MethodType)types.get(3);
        FACTORY_METHOD_TYPE = (MethodType)types.get(4);
        PACKET_SENDER = classes[0];
        HAS_EXTENDED_REACH = (MethodHandle)handles.get(5);
        GET_TICK_DELTA = (MethodHandle)handles.get(6);
        loggedItems = ConcurrentHashMap.newKeySet();
        lastRenderedStack = null;
        itemRecursionDepth = 0;
        maxItemRecursionDepth = 2;
        loggedEntityTypes = ConcurrentHashMap.newKeySet();
        lastRenderedEntity = null;
        entityRecursionDepth = 0;
        maxEntityRecursionDepth = 2;
    }
}

