/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.platform.fabric;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.mixin.accessor.BrewingRecipeRegistryRecipeAccessor;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.recipe.EmiBrewingRecipe;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.screen.FakeScreen;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1058;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import org.apache.commons.lang3.text.WordUtils;

public class EmiAgnosFabric
extends EmiAgnos {
    @Override
    protected boolean isForgeAgnos() {
        return false;
    }

    @Override
    protected String getModNameAgnos(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = FabricLoader.getInstance().getModContainer(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        container = FabricLoader.getInstance().getModContainer(namespace.replace('_', '-'));
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        return WordUtils.capitalizeFully((String)namespace.replace('_', ' '));
    }

    @Override
    protected Path getConfigDirectoryAgnos() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    protected boolean isDevelopmentEnvironmentAgnos() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    protected boolean isModLoadedAgnos(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    @Override
    protected List<String> getAllModNamesAgnos() {
        return FabricLoader.getInstance().getAllMods().stream().map(c -> c.getMetadata().getName()).toList();
    }

    @Override
    protected List<String> getAllModAuthorsAgnos() {
        return FabricLoader.getInstance().getAllMods().stream().flatMap(c -> c.getMetadata().getAuthors().stream()).map(p -> p.getName()).distinct().toList();
    }

    @Override
    protected List<String> getModsWithPluginsAgnos() {
        ArrayList list = Lists.newArrayList();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("emi", EmiPlugin.class)) {
            try {
                list.add(container.getProvider().getMetadata().getId());
            }
            catch (Throwable t) {
                EmiLog.error("Critical exception thrown when reading EMI Plugin from mod " + container.getProvider().getMetadata().getId(), t);
            }
        }
        return list;
    }

    @Override
    protected List<EmiPluginContainer> getPluginsAgnos() {
        ArrayList list = Lists.newArrayList();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("emi", EmiPlugin.class)) {
            try {
                list.add(new EmiPluginContainer((EmiPlugin)container.getEntrypoint(), container.getProvider().getMetadata().getId()));
            }
            catch (Throwable t) {
                EmiLog.error("Critical exception thrown when constructing EMI Plugin from mod " + container.getProvider().getMetadata().getId(), t);
            }
        }
        return list;
    }

    @Override
    protected void addBrewingRecipesAgnos(EmiRegistry registry) {
        for (class_1856 ingredient : class_1845.field_8957) {
            for (class_1799 stack : ingredient.method_8105()) {
                String pid = EmiUtil.subId(stack.method_7909());
                for (class_1845.class_1846 recipe : class_1845.field_8956) {
                    try {
                        class_1856 recipeIngredient = ((BrewingRecipeRegistryRecipeAccessor)recipe).getIngredient();
                        if (recipeIngredient.method_8105().length <= 0) continue;
                        class_2960 id = EmiPort.id("emi", "/brewing/" + pid + "/" + EmiUtil.subId(recipeIngredient.method_8105()[0].method_7909()) + "/" + EmiUtil.subId(EmiPort.getPotionRegistry().method_10221((Object)((class_1842)((BrewingRecipeRegistryRecipeAccessor)recipe).getInput()))) + "/" + EmiUtil.subId(EmiPort.getPotionRegistry().method_10221((Object)((class_1842)((BrewingRecipeRegistryRecipeAccessor)recipe).getOutput()))));
                        registry.addRecipe(new EmiBrewingRecipe(EmiStack.of(EmiPort.setPotion(stack.method_7972(), (class_1842)((BrewingRecipeRegistryRecipeAccessor)recipe).getInput())), EmiIngredient.of(recipeIngredient), EmiStack.of(EmiPort.setPotion(stack.method_7972(), (class_1842)((BrewingRecipeRegistryRecipeAccessor)recipe).getOutput())), id));
                    }
                    catch (Exception e) {
                        EmiLog.error("Error registering brewing recipe", e);
                    }
                }
            }
        }
        for (class_1845.class_1846 recipe : class_1845.field_8959) {
            try {
                class_1856 recipeIngredient = ((BrewingRecipeRegistryRecipeAccessor)recipe).getIngredient();
                if (recipeIngredient.method_8105().length <= 0) continue;
                String gid = EmiUtil.subId(recipeIngredient.method_8105()[0].method_7909());
                String iid = EmiUtil.subId((class_1792)((BrewingRecipeRegistryRecipeAccessor)recipe).getInput());
                String oid = EmiUtil.subId((class_1792)((BrewingRecipeRegistryRecipeAccessor)recipe).getOutput());
                Consumer<class_6880> potionRecipeGen = entry -> {
                    class_1842 potion = (class_1842)entry.comp_349();
                    if (potion == class_1847.field_8984) {
                        return;
                    }
                    if (class_1845.method_20361((class_1842)potion)) {
                        class_2960 id = new class_2960("emi", "/brewing/item/" + EmiUtil.subId(((class_5321)entry.method_40230().get()).method_29177()) + "/" + gid + "/" + iid + "/" + oid);
                        registry.addRecipe(new EmiBrewingRecipe(EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)((class_1792)((BrewingRecipeRegistryRecipeAccessor)recipe).getInput())), potion)), EmiIngredient.of(recipeIngredient), EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)((class_1792)((BrewingRecipeRegistryRecipeAccessor)recipe).getOutput())), potion)), id));
                    }
                };
                if (((BrewingRecipeRegistryRecipeAccessor)recipe).getInput() instanceof class_1812) {
                    EmiPort.getPotionRegistry().method_40270().forEach(potionRecipeGen);
                    continue;
                }
                potionRecipeGen.accept(EmiPort.getPotionRegistry().method_47983((Object)class_1847.field_8999));
            }
            catch (Exception e) {
                EmiLog.error("Error registering brewing recipe", e);
            }
        }
    }

    @Override
    protected List<class_5684> getItemTooltipAgnos(class_1799 stack) {
        return FakeScreen.INSTANCE.getTooltipComponentListFromItem(stack);
    }

    @Override
    protected class_2561 getFluidNameAgnos(class_3611 fluid, class_2487 nbt) {
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid, (class_2487)nbt));
    }

    @Override
    protected List<class_2561> getFluidTooltipAgnos(class_3611 fluid, class_2487 nbt) {
        return FluidVariantRendering.getTooltip((FluidVariant)FluidVariant.of((class_3611)fluid, (class_2487)nbt));
    }

    @Override
    protected boolean isFloatyFluidAgnos(FluidEmiStack stack) {
        FluidVariant fluid = FluidVariant.of((class_3611)stack.getKeyOfType(class_3611.class), (class_2487)stack.getNbt());
        return FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid);
    }

    @Override
    protected void renderFluidAgnos(FluidEmiStack stack, class_4587 matrices, int x, int y, float delta, int xOff, int yOff, int width, int height) {
        FluidVariant fluid = FluidVariant.of((class_3611)stack.getKeyOfType(class_3611.class), (class_2487)stack.getNbt());
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)fluid);
        if (sprites == null || sprites.length < 1 || sprites[0] == null) {
            return;
        }
        class_1058 sprite = sprites[0];
        int color = FluidVariantRendering.getColor((FluidVariant)fluid);
        EmiRenderHelper.drawTintedSprite(matrices, sprite, color, x, y, xOff, yOff, width, height);
    }

    @Override
    protected EmiStack createFluidStackAgnos(Object object) {
        return JemiUtil.getFluidFromJei(object);
    }

    @Override
    protected boolean canBatchAgnos(class_1799 stack) {
        return ColorProviderRegistry.ITEM.get((Object)stack.method_7909()) == null;
    }

    @Override
    protected Map<class_1792, Integer> getFuelMapAgnos() {
        Object2IntOpenHashMap fuelMap = new Object2IntOpenHashMap();
        for (class_1792 item : EmiPort.getItemRegistry()) {
            int time;
            if (FuelRegistry.INSTANCE.get((class_1935)item) == null || (time = ((Integer)FuelRegistry.INSTANCE.get((class_1935)item)).intValue()) <= 0) continue;
            fuelMap.put((Object)item, time);
        }
        return fuelMap;
    }

    static {
        EmiAgnos.delegate = new EmiAgnosFabric();
    }
}

