/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.classes;

import com.obscuria.obscureapi.api.ClassRegistry;
import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import com.obscuria.obscureapi.common.classes.ClassItem;
import com.obscuria.obscureapi.common.classes.GameClass;
import com.obscuria.obscureapi.common.classes.ability.Ability;
import com.obscuria.obscureapi.common.classes.ability.RegisterAbility;
import com.obscuria.obscureapi.common.classes.bonus.Bonus;
import com.obscuria.obscureapi.common.classes.bonus.RegisterBonus;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public final class GameClassHelper {
    public static boolean hasClass(class_1799 stack) {
        return ByAnnotation.hasClass(stack.method_7909()) || ByTag.hasClass(stack);
    }

    public static boolean hasClass(class_1792 item) {
        return ByAnnotation.hasClass(item);
    }

    public static boolean hasClass(Class<? extends class_1792> item) {
        return ByAnnotation.hasClass(item);
    }

    public static Optional<GameClass> getClass(class_1799 stack) {
        if (ByAnnotation.hasClass(stack.method_7909())) {
            return ByAnnotation.getClass(stack.method_7909());
        }
        if (ByTag.hasClass(stack)) {
            return ByTag.getClass(stack);
        }
        return Optional.empty();
    }

    public static Optional<GameClass> getClass(class_1792 item) {
        if (ByAnnotation.hasClass(item)) {
            return ByAnnotation.getClass(item);
        }
        return Optional.empty();
    }

    public static Optional<GameClass> getClass(Class<? extends class_1792> item) {
        if (ByAnnotation.hasClass(item)) {
            return ByAnnotation.getClass(item);
        }
        return Optional.empty();
    }

    public static Optional<String> getType(class_1799 stack) {
        if (ByAnnotation.hasClass(stack.method_7909())) {
            return ByAnnotation.getType(stack.method_7909());
        }
        if (ByTag.hasClass(stack)) {
            return ByTag.getType(stack);
        }
        return Optional.empty();
    }

    public static Optional<String> getType(class_1792 item) {
        if (ByAnnotation.hasClass(item)) {
            return ByAnnotation.getType(item);
        }
        return Optional.empty();
    }

    public static Optional<String> getType(Class<? extends class_1792> item) {
        if (ByAnnotation.hasClass(item)) {
            return ByAnnotation.getType(item);
        }
        return Optional.empty();
    }

    public static boolean hasBonuses(class_1799 stack) {
        return ByAnnotation.hasClass(stack.method_7909()) && !ByAnnotation.getAllBonuses(stack.method_7909()).isEmpty();
    }

    public static boolean hasBonuses(class_1792 item) {
        return ByAnnotation.hasClass(item) && !ByAnnotation.getAllBonuses(item).isEmpty();
    }

    public static boolean hasVisibleBonuses(class_1799 stack) {
        return ByAnnotation.hasClass(stack.method_7909()) && !ByAnnotation.getVisibleBonuses(stack.method_7909()).isEmpty();
    }

    public static boolean hasVisibleBonuses(class_1792 item) {
        return ByAnnotation.hasClass(item) && !ByAnnotation.getVisibleBonuses(item).isEmpty();
    }

    public static List<Bonus> getAllBonuses(class_1799 stack) {
        return ByAnnotation.getAllBonuses(stack.method_7909());
    }

    public static List<Bonus> getAllBonuses(class_1792 item) {
        return ByAnnotation.getAllBonuses(item);
    }

    public static List<Bonus> getVisibleBonuses(class_1799 stack) {
        return ByAnnotation.getVisibleBonuses(stack.method_7909());
    }

    public static List<Bonus> getVisibleBonuses(class_1792 item) {
        return ByAnnotation.getVisibleBonuses(item);
    }

    public static boolean hasAbilities(class_1792 item) {
        return ByAnnotation.hasClass(item) && !ByAnnotation.getAllAbilities(item).isEmpty();
    }

    public static boolean hasVisibleAbilities(class_1792 item) {
        return ByAnnotation.hasClass(item) && !ByAnnotation.getVisibleAbilities(item).isEmpty();
    }

    public static List<Ability> getAllAbilities(class_1792 item) {
        return ByAnnotation.getAllAbilities(item);
    }

    public static List<Ability> getVisibleAbilities(class_1792 item) {
        return ByAnnotation.getVisibleAbilities(item);
    }

    protected static class ByAnnotation {
        protected ByAnnotation() {
        }

        public static boolean hasClass(class_1792 item) {
            return item.getClass().isAnnotationPresent(ClassItem.class);
        }

        public static boolean hasClass(Class<? extends class_1792> item) {
            return item.isAnnotationPresent(ClassItem.class);
        }

        public static Optional<GameClass> getClass(class_1792 item) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(ClassRegistry.get(new class_2960(item.getClass().getAnnotation(ClassItem.class).value()))));
        }

        public static Optional<GameClass> getClass(Class<? extends class_1792> item) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(ClassRegistry.get(new class_2960(item.getAnnotation(ClassItem.class).value()))));
        }

        public static Optional<String> getType(class_1792 item) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(item.getClass().getAnnotation(ClassItem.class).type()));
        }

        public static Optional<String> getType(Class<? extends class_1792> item) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(item.getAnnotation(ClassItem.class).type()));
        }

        public static List<Bonus> getAllBonuses(class_1792 item) {
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            for (Field field : item.getClass().getFields()) {
                if (!field.getType().isAssignableFrom(Bonus.class) || !field.isAnnotationPresent(RegisterBonus.class)) continue;
                try {
                    bonuses.add(0, (Bonus)field.get(item));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bonuses;
        }

        public static List<Bonus> getVisibleBonuses(class_1792 item) {
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            for (Field field : item.getClass().getFields()) {
                if (!field.getType().isAssignableFrom(Bonus.class) || !field.isAnnotationPresent(RegisterBonus.class) || !field.getAnnotation(RegisterBonus.class).visible()) continue;
                try {
                    bonuses.add(0, (Bonus)field.get(item));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bonuses;
        }

        public static List<Ability> getAllAbilities(class_1792 item) {
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            for (Field field : item.getClass().getFields()) {
                if (!field.getType().isAssignableFrom(Ability.class) || !field.isAnnotationPresent(RegisterAbility.class)) continue;
                try {
                    abilities.add(0, (Ability)field.get(item));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return abilities;
        }

        public static List<Ability> getVisibleAbilities(class_1792 item) {
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            for (Field field : item.getClass().getFields()) {
                if (!field.getType().isAssignableFrom(Ability.class) || !field.isAnnotationPresent(RegisterAbility.class) || !field.getAnnotation(RegisterAbility.class).visible()) continue;
                try {
                    abilities.add(0, (Ability)field.get(item));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return abilities;
        }
    }

    protected static class ByTag {
        protected ByTag() {
        }

        public static boolean hasClass(class_1799 stack) {
            return ExceptionFilter.equals(true, () -> stack.method_7969().method_10545("GameClass"));
        }

        public static Optional<GameClass> getClass(class_1799 stack) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(ClassRegistry.get(new class_2960(stack.method_7969().method_10562("GameClass").method_10558("Name")))));
        }

        public static Optional<String> getType(class_1799 stack) {
            return ExceptionFilter.getNoNull(Optional.empty(), () -> Optional.of(stack.method_7969().method_10562("GameClass").method_10558("Type")));
        }
    }
}

