/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.classes.bonus;

import com.obscuria.obscureapi.api.ClassRegistry;
import com.obscuria.obscureapi.api.utils.TextUtils;
import com.obscuria.obscureapi.common.classes.GameClass;
import com.obscuria.obscureapi.common.classes.GameClassHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;

public class Bonus {
    private final GameClass ITEM_CLASS;
    private final String ITEM_TYPE;
    private final Type TYPE;
    private final Operation OPERATION;
    private final int VALUE;

    @Contract(pure=true)
    private Bonus(Builder builder) {
        this.ITEM_CLASS = builder.itemClass;
        this.ITEM_TYPE = builder.itemType;
        this.TYPE = builder.bonusType;
        this.OPERATION = builder.operation;
        this.VALUE = builder.value;
    }

    @Contract(value=" -> new")
    public static Builder create() {
        return new Builder();
    }

    public String getBonusString() {
        return TextUtils.translation("class_bonus." + this.ITEM_TYPE + "_" + this.TYPE.getName() + "." + (this.VALUE >= 0 ? "plus" : "minus")).replace("#", this.VALUE + this.OPERATION.getName());
    }

    public boolean canApply(class_1792 item) {
        if (!GameClassHelper.hasClass(item)) {
            return false;
        }
        if (!GameClassHelper.getClass(item).orElse(ClassRegistry.BLANK).equals(this.ITEM_CLASS)) {
            return false;
        }
        return GameClassHelper.getType(item).orElse("null").equals(this.ITEM_TYPE);
    }

    public boolean canApply(GameClass clazz, String type) {
        return clazz.equals(this.ITEM_CLASS) && type.equals(this.ITEM_TYPE);
    }

    public boolean canApply(GameClass clazz, String type, Type bonusType, Operation operation) {
        return this.canApply(clazz, type) && bonusType.equals((Object)this.TYPE) && operation.equals((Object)this.OPERATION);
    }

    public GameClass getItemClass() {
        return this.ITEM_CLASS;
    }

    public String getItemType() {
        return this.ITEM_TYPE;
    }

    public Type getType() {
        return this.TYPE;
    }

    public Operation getOperation() {
        return this.OPERATION;
    }

    public int getValue() {
        return this.VALUE;
    }

    public static class Builder {
        private GameClass itemClass = ClassRegistry.BLANK;
        private String itemType = "blank";
        private Type bonusType = Type.POWER;
        private Operation operation = Operation.AMOUNT;
        private int value;

        private Builder() {
        }

        public Builder target(String clazz, String type) {
            return this.target(ClassRegistry.get(new class_2960(clazz)), type);
        }

        public Builder target(GameClass clazz, String type) {
            this.itemClass = clazz;
            this.itemType = type;
            return this;
        }

        public Builder type(Type type, Operation operation) {
            this.bonusType = type;
            this.operation = operation;
            return this;
        }

        public Builder value(int v) {
            this.value = v;
            return this;
        }

        public Bonus build() {
            return new Bonus(this);
        }
    }

    public static enum Type {
        POWER("power"),
        COOLDOWN("cooldown");

        private final String NAME;

        private Type(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }

    public static enum Operation {
        AMOUNT(""),
        PERCENT("%");

        private final String NAME;

        private Operation(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }
}

