/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigPreviewer;
import me.shedaniel.rei.impl.client.gui.config.options.OptionValueEntry;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class CompositeOption<T> {
    private final String id;
    private final class_2561 name;
    private final class_2561 description;
    private final Function<ConfigObjectImpl, T> bind;
    private final BiConsumer<ConfigObjectImpl, T> save;
    @Nullable
    private ConfigPreviewer<T> previewer;
    @Nullable
    private Supplier<T> defaultValue = null;
    private OptionValueEntry<T> entry = OptionValueEntry.noOp();
    private boolean requiresLevel = false;
    @Nullable
    private String optionNameHighlight = null;
    @Nullable
    private String optionDescriptionHighlight = null;

    public CompositeOption(String id, class_2561 name, class_2561 description, Function<ConfigObjectImpl, T> bind, BiConsumer<ConfigObjectImpl, T> save) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.bind = bind;
        this.save = save;
    }

    public CompositeOption<T> entry(OptionValueEntry<T> entry) {
        this.entry = entry;
        return this;
    }

    public CompositeOption<Boolean> ofBoolean(class_2561 falseText, class_2561 trueText) {
        return this.entry(OptionValueEntry.ofBoolean(falseText, trueText));
    }

    public CompositeOption<Boolean> trueFalse() {
        return this.entry(OptionValueEntry.trueFalse());
    }

    public CompositeOption<Boolean> enabledDisabled() {
        return this.entry(OptionValueEntry.enabledDisabled());
    }

    public CompositeOption<ModifierKeyCode> keybind() {
        return this.entry(OptionValueEntry.keybind());
    }

    public CompositeOption<String> string() {
        return this.entry(OptionValueEntry.string());
    }

    public CompositeOption<T> enumOptions(T ... entry) {
        return this.entry(OptionValueEntry.enumOptions(entry));
    }

    public CompositeOption<T> options(T ... entry) {
        return this.entry(OptionValueEntry.options(entry));
    }

    public CompositeOption<T> configure(OptionValueEntry.Configurator<T> configurator) {
        return this.entry(OptionValueEntry.configure(configurator));
    }

    public CompositeOption<T> details(OptionValueEntry.Configurator<T> configurator) {
        return this.entry(OptionValueEntry.details(configurator));
    }

    public CompositeOption<T> reload(OptionValueEntry.Configurator<T> configurator) {
        return this.entry(OptionValueEntry.reload(configurator));
    }

    public CompositeOption<T> requiresLevel() {
        this.requiresLevel = true;
        return this;
    }

    public void setOptionNameHighlight(@Nullable String optionNameHighlight) {
        this.optionNameHighlight = optionNameHighlight;
    }

    public void setOptionDescriptionHighlight(@Nullable String optionDescriptionHighlight) {
        this.optionDescriptionHighlight = optionDescriptionHighlight;
    }

    public boolean isRequiresLevel() {
        return this.requiresLevel;
    }

    @Nullable
    public String getOptionNameHighlight() {
        return this.optionNameHighlight;
    }

    @Nullable
    public String getOptionDescriptionHighlight() {
        return this.optionDescriptionHighlight;
    }

    public CompositeOption<T> previewer(ConfigPreviewer<T> previewer) {
        this.previewer = previewer;
        return this;
    }

    public CompositeOption<T> defaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public Function<ConfigObjectImpl, T> getBind() {
        return this.bind;
    }

    public BiConsumer<ConfigObjectImpl, T> getSave() {
        return this.save;
    }

    public OptionValueEntry<T> getEntry() {
        return this.entry;
    }

    @Nullable
    public ConfigPreviewer<T> getPreviewer() {
        return this.previewer;
    }

    public boolean hasPreview() {
        return this.previewer != null;
    }

    @Nullable
    public T getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.get();
    }

    public CompositeOption<T> copy() {
        CompositeOption<T> option = new CompositeOption<T>(this.id, this.name, this.description, this.bind, this.save);
        option.entry = this.entry;
        option.previewer = this.previewer;
        option.defaultValue = this.defaultValue;
        option.requiresLevel = this.requiresLevel;
        return option;
    }
}

